import React from 'react'
import DefaultView from 'views/DefaultView'
import { Grid, Panel, utils } from 'react-bootstrap'
import { Link } from 'react-router'
import ErrorAlert from 'components/ErrorAlert'
import Service from 'modules/api_data/objects/Service'
import { ServiceType } from 'modules/api_data/types'
import './EnrollResult.scss'

import { resetAppStateExcept } from 'store/reducers'

utils.bootstrapUtils.addStyle(Panel, 'twitchPurple')

export default class EnrollResult extends DefaultView {

  componentDidMount () {
    this.props.dispatch(resetAppStateExcept('enroll'))
  }

  documentTitle () {
    return 'Project Enrollment'
  }

  errorTitle () {
    return 'Failed to Enroll Project!'
  }

  renderError () {
    let header = this.errorTitle()
    let message = this.props.error
    let errorMsg = ''
    try {
      const parsed = JSON.parse(this.props.error)
      header = parsed.Error
      message = parsed.Error
      errorMsg = `Code: ${parsed.Code}`
    } catch (e) { }
    return (
      <ErrorAlert
        header={header}
        message={message}
        error={errorMsg}
      />
    )
  }

  renderContent () {
    let project = new Service(this.props.params.projectId, this.props.params.projectName, ServiceType.PROJECT)
    let internalTapUrl = <a href='http://link.twitch.tv/homebrew'>Twitch Internal Tap</a>
    let blueprintUrl = <a href='http://link.twitch.tv/rps-enroll'>http://link.twitch.tv/rps-enroll</a>
    return (
      <Grid style={{ marginTop: '40px' }}>
        <Panel bsStyle='twitchPurple' className='twitchPurple' header='Enrollment Successful!'>
          <p>
            <Link to={project.url}>{project.name}</Link> is now enrolled in RPS!
          </p>
          <p>
            RPS will now begin collecting applicable metrics for your project based on the enrollment data you
            entered.
          </p>
          <p>
            If you need to change any of this enrollment data, then you may use the command line tool rpstool.
          </p>
          <p>
            Eventually we will have an Edit Page, but for now the command-line tool is the way to go.
          </p>
          <p>To use it, do the following:</p>
          <p>1. Install rpstool via brew (make sure you have the {internalTapUrl} setup):</p>
          <pre>brew install rpstool</pre>
          <p>2. Enter the directory where you have your project checked out and run:</p>
          <pre>rpstool enroll</pre>
          <p>
            This will generate a blueprint file, which you can then edit to change enrollment data.
          </p>
          <p>
            For more information, see here: {blueprintUrl}
          </p>
        </Panel>
      </Grid>
    )
  }
}

EnrollResult.propTypes = {
  projectId: React.PropTypes.string,
  projectName: React.PropTypes.string,
  dispatch: React.PropTypes.any,
  params: React.PropTypes.any,
  error: React.PropTypes.any
}
