import React from 'react'
import DefaultView from 'views/DefaultView'
import { Grid, PageHeader, Image } from 'react-bootstrap'
import RpsImage from '../assets/rps.png'
import './Home.scss'

export default class HomeView extends DefaultView {

  errorTitle () {
    return `Error: Failed to load home page`
  }

  documentTitle () {
    return `RPS`
  }

  renderContent () {
    return (
      <Grid style={{ marginTop: '40px' }}>
        <PageHeader className='text-center'>Welcome to RPS</PageHeader>
        <Image className='center-block' src={RpsImage} responsive />
        <br />
        <center>
          <h4>
            Rock Paper Scissors
            <br />
            <small>
              Realtime Product Signals
            </small>
          </h4>
          <hr />
        </center>
        <p>
          RPS is a system for collecting software project health metrics such as time between releases, code
          churn, test coverage, etc.
        </p>
        <p>
          It's also gamified so that teams can compare their progress and are encouraged to follow best
          practices in order to gain higher levels and score points.
        </p>
        <p>
          For more information on RPS, checkout the links below:
        </p>
        <ul>
          <li><a href='http://link.twitch.tv/dta-rps-preso' target='_blank'>Slide Deck</a></li>
          <li><a href='http://link.twitch.tv/dta-rps-design' target='_blank'>Design Doc</a></li>
          <li>
            <a
              href='https://git-aws.internal.justin.tv/dta/rockpaperscissors/blob/master/client/web/README.md'
              target='_blank'>
              Design Doc (Front-End)
            </a>
          </li>
          <li><a href='http://link.twitch.tv/dta-rps-wiki' target='_blank'>Jira Wiki Page</a></li>
        </ul>
      </Grid>
    )
  }
}
