import React from 'react'
import DefaultView from 'views/DefaultView'
import MetricsTable from '../containers/MetricsTable'
import BucketSelector from 'containers/BucketSelector'
import BucketTypeSelector from 'containers/BucketTypeSelector'
import RangeTypeSelector from 'containers/RangeTypeSelector'
import ToggleMetrics from 'containers/ToggleMetrics'
import { BucketType, RangeType } from 'modules/api_data/types'
import { fetchMetricsData } from 'modules/metrics_data/actions'
import { fetchMetricsRoute } from '../actions'
import { Grid, Row, Col, ButtonGroup, Button } from 'react-bootstrap'
import './Metrics.scss'

export default class Metrics extends DefaultView {

  constructor (props) {
    super(props)
    this.state = {
      hideToggleMetrics: true
    }
    this.toggleToggleMetrics = this.toggleToggleMetrics.bind(this)
    this.hideToggleMetrics = this.hideToggleMetrics.bind(this)
    this.onExpandToggle = this.onExpandToggle.bind(this)
  }

  componentDidMount () {
    let bucketType
    let rangeType
    let metricIds
    const urlQuery = this.props.location.query
    if (urlQuery !== undefined) {
      bucketType = urlQuery.bucketType
      if (bucketType !== undefined) {
        bucketType = BucketType.enumValueOf(bucketType.toUpperCase())
      }
      rangeType = urlQuery.rangeType
      if (rangeType !== undefined) {
        rangeType = RangeType.enumValueOf(rangeType.toUpperCase())
      }
      metricIds = urlQuery.metrics
      if (metricIds !== undefined) {
        metricIds = metricIds.split(',')
      }
    }
    this.props.dispatch(
      fetchMetricsRoute(undefined, metricIds, rangeType, bucketType, this.props.reducerKey, this.props.urlStr)
    )
  }

  toggleToggleMetrics () {
    this.setState({ hideToggleMetrics: !this.state.hideToggleMetrics })
  }

  hideToggleMetrics (isHidden) {
    if (!isHidden) {
      this.setState({ hideToggleMetrics: true })
    }
  }

  // Set the curServiceId through the reducer instead of through state.

  onExpandToggle (rowId) {
    const serviceId = rowId.split('.').slice(-1)[0]
    const service = this.props.services[serviceId]
    let serviceIds = service.children
    let curServiceIds = Object.assign([], this.props.curServiceIds)
    serviceIds.forEach((serviceId) => {
      const idxOfServiceId = curServiceIds.indexOf(serviceId)
      if (idxOfServiceId >= 0) {
        curServiceIds.splice(idxOfServiceId, 1)
      } else {
        curServiceIds.push(serviceId)
      }
    })
    this.props.dispatch(
      fetchMetricsData(curServiceIds, undefined, undefined, undefined, this.props.reducerKey, this.props.urlStr)
    )
  }

  documentTitle () {
    return 'Metrics'
  }

  renderContent () {
    let header
    if (this.props.curBucketName) {
      header = <h3>Viewing {this.props.curBucketName}</h3>
    }

    return (
      <Grid>
        <Row style={{ marginBottom: '20px' }}>
          <Col sm={6}>
            {header}
          </Col>
          <Col sm={6}>
            <table style={{ marginTop: '20px' }} className='graph-controls-table'>
              <tbody>
                <tr>
                  <td className='graph-controls-buttons-col'>
                    <ButtonGroup>
                      <BucketTypeSelector
                        disabled={this.props.loading}
                        reducerKey={this.props.reducerKey}
                        urlStr={this.props.urlStr}
                      />
                      <RangeTypeSelector
                        disabled={this.props.loading}
                        reducerKey={this.props.reducerKey}
                        urlStr={this.props.urlStr}
                      />
                      <Button disabled={this.props.loading} onClick={this.toggleToggleMetrics}>
                        Metrics <span className='caret' />
                      </Button>
                    </ButtonGroup>
                  </td>
                </tr>
              </tbody>
            </table>
          </Col>
        </Row>
        <Row>
          <Col sm={12}>
            <ToggleMetrics
              hidden={this.state.hideToggleMetrics}
              onClickOutside={this.hideToggleMetrics}
              reducerKey={this.props.reducerKey}
              urlStr={this.props.urlStr}
            />
          </Col>
        </Row>
        <Row>
          <Col style={{ marginBottom: '40px' }} sm={12}>
            <BucketSelector
              reducerKey={this.props.reducerKey}
            />
          </Col>
        </Row>
        <Row>
          <Col sm={12}>
            <MetricsTable
              metrics={this.props.curMetricIds}
              onExpand={this.onExpandToggle}
            />
          </Col>
        </Row>
      </Grid>
    )
  }
}
