import { connect } from 'react-redux'
import Metrics from '../components/Metrics'
import { REDUCER_KEY } from '../reducers/metrics_table'
import UrlUtils from 'utils/UrlUtils'

const mapStateToProps = (state, ownProps) => {
  const error = state.metrics_table.error
  const loading = state.metrics_table.loading

  let curRangeType = state[REDUCER_KEY].curRangeType
  let curBucketType = state[REDUCER_KEY].curBucketType
  let curMetricIds = state[REDUCER_KEY].curMetricIds
  let curServiceIds = state[REDUCER_KEY].curServiceIds

  let curBucketName = state[REDUCER_KEY].curBucketId
  if (curBucketName !== undefined) {
    curBucketName = state.api_data.buckets[curBucketName]
    if (curBucketName !== undefined) {
      curBucketName = curBucketName.name
    }
  }

  const urlStr = UrlUtils.getMetricsUrl()

  return {
    error,
    loading,
    services: state.api_data.services,
    orgIds: state.api_data.orgIds,
    curServiceIds,
    curMetricIds,
    curBucketType,
    curRangeType,
    curBucketName,
    urlStr,
    reducerKey: REDUCER_KEY
  }
}

export default connect(mapStateToProps)(Metrics)
