import { combineReducers } from 'redux'
import { BucketType, RangeType } from 'modules/api_data/types'
import {
  REQUEST_METRICS_ROUTE,
  RECEIVE_METRICS_ROUTE,
  RECEIVE_METRICS_ROUTE_ERROR
} from '../actions'
import {
  SET_CUR_SERVICE_IDS,
  SET_CUR_METRIC_IDS,
  SET_CUR_BUCKET_ID,
  SET_CUR_BUCKET_TYPE,
  SET_CUR_TIME_RANGE
} from 'modules/metrics_data/actions'

export const REDUCER_KEY = 'metrics_table'

const loading = (state = true, action) => {
  switch (action.type) {
    case REQUEST_METRICS_ROUTE:
      return true
    case RECEIVE_METRICS_ROUTE:
    case RECEIVE_METRICS_ROUTE_ERROR:
      return false
    default:
      return state
  }
}

const error = (state = null, action) => {
  switch (action.type) {
    default:
      return state
  }
}

const curRangeEnd = (state = '', action) => {
  switch (action.type) {
    case SET_CUR_TIME_RANGE:
      if (action.reducerKey !== REDUCER_KEY) {
        return state
      }
      return action.endTime
    default:
      return state
  }
}

const curRangeType = (state = RangeType.LAST_WEEK, action) => {
  switch (action.type) {
    case SET_CUR_TIME_RANGE:
      if (action.reducerKey !== REDUCER_KEY) {
        return state
      }
      return action.rangeType
    default:
      return state
  }
}

const curBucketId = (state = '', action) => {
  switch (action.type) {
    case SET_CUR_BUCKET_ID:
      if (action.reducerKey !== REDUCER_KEY) {
        return state
      }
      return action.bucketId
    default:
      return state
  }
}

const curBucketType = (state = BucketType.DAY, action) => {
  switch (action.type) {
    case SET_CUR_BUCKET_TYPE:
      if (action.reducerKey !== REDUCER_KEY) {
        return state
      }
      return action.bucketType
    default:
      return state
  }
}

const curValidBucketTypes = (state = [BucketType.DAY], action) => {
  switch (action.type) {
    case SET_CUR_TIME_RANGE:
      if (action.reducerKey !== REDUCER_KEY) {
        return state
      }
      if (action.rangeType === RangeType.LAST_DAY) {
        return [BucketType.DAY]
      } else if (action.rangeType === RangeType.LAST_WEEK) {
        return [BucketType.DAY, BucketType.WEEK]
      } else if (action.rangeType === RangeType.LAST_MONTH) {
        return [BucketType.DAY, BucketType.WEEK, BucketType.MONTH]
      }
      return [BucketType.WEEK, BucketType.MONTH, BucketType.YEAR]
    default:
      return state
  }
}

const curServiceIds = (state = [], action) => {
  switch (action.type) {
    case SET_CUR_SERVICE_IDS:
      if (action.reducerKey !== REDUCER_KEY) {
        return state
      }
      return action.serviceIds
    default:
      return state
  }
}

const curMetricIds = (state = [], action) => {
  switch (action.type) {
    case SET_CUR_METRIC_IDS:
      if (action.reducerKey !== REDUCER_KEY) {
        return state
      }
      return action.metricIds
    default:
      return state
  }
}

export default combineReducers({
  loading,
  error,
  curBucketId,
  curBucketType,
  curValidBucketTypes,
  curRangeEnd,
  curRangeType,
  curServiceIds,
  curMetricIds
})
