import React from 'react'
import { Link } from 'react-router'

export default class ServiceCrumb extends React.Component {

  getParentCrumbData (service) {
    if (service.parent === undefined) {
      return []
    }
    const parent = this.props.services[service.parent]
    return [parent, ...this.getParentCrumbData(parent)]
  }

  getCrumbs () {
    const service = this.props.services[this.props.serviceId]
    let crumbs = []
    let services = this.getParentCrumbData(service)
    for (var idx = (services.length - 1); idx >= 0; idx--) {
      let service = services[idx]
      crumbs.push(
        <Link to={service.url} key={idx}>
          {service.name}
        </Link>
      )
      crumbs.push(<span key={`${idx}.1`}> / </span>)
    }
    return crumbs
  }

  render () {
    return (
      <h4>
        <small>
          {this.getCrumbs()}
        </small>
      </h4>
    )
  }
}

ServiceCrumb.propTypes = {
  serviceId: React.PropTypes.string,
  services: React.PropTypes.any
}
