import React from 'react'
import DefaultView from 'views/DefaultView'
import ServiceListEntry from './ServiceListEntry'
import Utils from 'utils/Utils'
import { ServiceType } from 'modules/api_data/types'
import { fetchServiceListData } from '../actions'
import { Grid } from 'react-bootstrap'
import './ServiceList.scss'

export default class ServiceList extends DefaultView {

  componentDidMount () {
    // Grab our rangeType and bucketType from the URL and start loading our Grid.
    this.props.dispatch(fetchServiceListData(this.props.serviceType))
  }

  errorTitle () {
    return `Error: Failed to load list of ${Utils.getPluralOfServiceType(this.props.serviceType).toLowerCase()}`
  }

  documentTitle () {
    return `${Utils.getTitleCase(Utils.getPluralOfServiceType(this.props.serviceType))}`
  }

  renderContent () {
    // If we're good to go, then return the content.
    const serviceTypeStr = Utils.getPluralOfServiceType(this.props.serviceType).toLowerCase()
    const serviceCount = this.props.serviceIds.length
    const serviceBoxes = this.renderServiceBoxes()

    return (
      <Grid>
        <h1>There are {serviceCount} {serviceTypeStr} enrolled</h1>
        <hr />
        {/* <table className='graph-controls-table'>
          <tbody>
            <tr>
              <td className='graph-controls-buttons-col'>
                <ButtonGroup>
                  <Button>Sort By Name</Button>
                </ButtonGroup>
              </td>
            </tr>
          </tbody>
        </table> */}
        {serviceBoxes}
      </Grid>
    )
  }

  renderServiceBoxes () {
    return this.props.serviceIds.map((serviceId, idx) => {
      return <ServiceListEntry key={idx} serviceId={serviceId} services={this.props.services} />
    })
  }
}

ServiceList.propTypes = {
  serviceType: React.PropTypes.instanceOf(ServiceType)
}
