import { connect } from 'react-redux'
import { ServiceType } from 'modules/api_data/types'
import ServiceList from '../../../components/ServiceList'

const mapStateToProps = (state, ownProps) => {
  let error = state.org_list.error
  const loading = state.org_list.loading

  // Type of services we want to list.
  let serviceType = ServiceType.ORG

  return {
    error,
    loading,
    serviceType,
    serviceIds: state.api_data.orgIds,
    services: state.api_data.services
  }
}

export default connect(mapStateToProps)(ServiceList)
