import DefaultLayout from 'layouts/DefaultLayout'
import { injectReducer } from 'store/reducers'
import OrgInfo from './routes/OrgInfo'

const route = (store) => ({
  getComponent (nextState, next) {
    require.ensure([], (require) => {
      const component = require('./containers/OrgList').default
      const reducer = require('./reducers/org_list').default
      injectReducer(store, {
        key: 'org_list',
        reducer: reducer
      })
      next(null, component)
    })
  }
})

export default (store) => ({
  path: 'orgs',
  component   : DefaultLayout,
  indexRoute  : route(store),
  childRoutes: [
    OrgInfo(store)
  ]
})
