import { combineReducers } from 'redux'
import { ServiceType } from 'modules/api_data/types'
import {
  REQUEST_SERVICE_LIST_DATA,
  RECEIVE_SERVICE_LIST_DATA,
  RECEIVE_SERVICE_LIST_DATA_ERROR
} from '../../../actions'

const loading = (state = true, action) => {
  switch (action.type) {
    case REQUEST_SERVICE_LIST_DATA:
      if (action.serviceType === ServiceType.ORG) {
        return true
      }
      return state
    case RECEIVE_SERVICE_LIST_DATA:
    case RECEIVE_SERVICE_LIST_DATA_ERROR:
      if (action.serviceType === ServiceType.ORG) {
        return false
      }
      return state
    default:
      return state
  }
}

const error = (state = null, action) => {
  switch (action.type) {
    case REQUEST_SERVICE_LIST_DATA:
      if (action.serviceType === ServiceType.ORG) {
        return null
      }
      return state
    case RECEIVE_SERVICE_LIST_DATA_ERROR:
      if (action.serviceType === ServiceType.ORG) {
        return action.error.toString()
      }
      return state
    default:
      return state
  }
}

export default combineReducers({
  loading,
  error
})
