import { connect } from 'react-redux'
import OrgInfo from '../components/OrgInfo'
import { ServiceType } from 'modules/api_data/types'
import { ORG_GRAPH_REDUCER_KEY } from '../reducers/org_graph'

const mapStateToProps = (state, ownProps) => {
  const error = state.org_info.error
  const loading = state.org_info.loading
  const serviceId = ownProps.params.orgId

  return {
    error,
    loading,
    serviceId,
    serviceType: ServiceType.ORG,
    services: state.api_data.services,
    metrics: state.api_data.metrics,
    metricIds: state.api_data.metricIds,
    reducerKeys: [ORG_GRAPH_REDUCER_KEY],
    selectedTab: ownProps.params.selectedTab
  }
}

export default connect(mapStateToProps)(OrgInfo)
