import { injectReducer } from 'store/reducers'

export default (store) => ({
  path: ':orgId(/:selectedTab)',
  getComponent (nextState, next) {
    require.ensure([], (require) => {
      const component = require('./containers/OrgInfo').default
      let reducer = require('./reducers/org_info').default
      injectReducer(store, {
        key: 'org_info',
        reducer: reducer
      })
      reducer = require('./reducers/org_graph').default
      injectReducer(store, {
        key: 'org_graph',
        reducer: reducer
      })
      next(null, component)
    })
  }
})
