import { connect } from 'react-redux'
import { ServiceType } from 'modules/api_data/types'
import ServiceList from '../../../components/ServiceList'

const mapStateToProps = (state, ownProps) => {
  let error = state.project_list.error
  const loading = state.project_list.loading

  // Type of services we want to list.
  let serviceType = ServiceType.PROJECT

  return {
    error,
    loading,
    serviceType,
    serviceIds: state.api_data.projectIds,
    services: state.api_data.services
  }
}

export default connect(mapStateToProps)(ServiceList)
