import DefaultLayout from 'layouts/DefaultLayout'
import { injectReducer } from 'store/reducers'
import ProjectInfo from './routes/ProjectInfo'

const route = (store) => ({
  getComponent (nextState, next) {
    require.ensure([], (require) => {
      const component = require('./containers/ProjectList').default
      const reducer = require('./reducers/project_list').default
      injectReducer(store, {
        key: 'project_list',
        reducer: reducer
      })
      next(null, component)
    })
  }
})

export default (store) => ({
  path: 'projects',
  component   : DefaultLayout,
  indexRoute  : route(store),
  childRoutes: [
    ProjectInfo(store)
  ]
})
