import { injectReducer } from 'store/reducers'

export default (store) => ({
  path: ':projectId(/:selectedTab)',
  getComponent (nextState, next) {
    require.ensure([], (require) => {
      const component = require('./containers/ProjectInfo').default
      let reducer = require('./reducers/project_info').default
      injectReducer(store, {
        key: 'project_info',
        reducer: reducer
      })
      reducer = require('./reducers/project_graph').default
      injectReducer(store, {
        key: 'project_graph',
        reducer: reducer
      })
      next(null, component)
    })
  }
})
