import { combineReducers } from 'redux'
import { BucketType, RangeType, ServiceType } from 'modules/api_data/types'
import { LOCATION_CHANGE } from 'store/location'
import {
  SET_CUR_SERVICE_IDS,
  SET_CUR_METRIC_IDS,
  SET_CUR_BUCKET_ID,
  SET_CUR_BUCKET_TYPE,
  SET_CUR_TIME_RANGE
} from 'modules/metrics_data/actions'
import {
  REQUEST_SERVICE_INFO_DATA,
  RECEIVE_SERVICE_INFO_DATA,
  RECEIVE_SERVICE_INFO_DATA_ERROR
} from 'routes/Services/actions'

export const PROJECT_INFO_REDUCER_KEY = 'project_info'

const loading = (state = true, action) => {
  switch (action.type) {
    case LOCATION_CHANGE:
      if (action.payload.pathname.startsWith('/projects/') && action.payload.action === 'PUSH') {
        return true
      }
      return state
    case REQUEST_SERVICE_INFO_DATA:
      if (action.serviceType === ServiceType.PROJECT) {
        return true
      }
      return state
    case RECEIVE_SERVICE_INFO_DATA:
    case RECEIVE_SERVICE_INFO_DATA_ERROR:
      if (action.serviceType === ServiceType.PROJECT) {
        return false
      }
      return state
    default:
      return state
  }
}

const error = (state = null, action) => {
  switch (action.type) {
    case LOCATION_CHANGE:
      if (action.payload.pathname.startsWith('/projects/') && action.payload.action === 'PUSH') {
        return null
      }
      return state
    case REQUEST_SERVICE_INFO_DATA:
      if (action.serviceType === ServiceType.PROJECT) {
        return null
      }
      return state
    case RECEIVE_SERVICE_INFO_DATA_ERROR:
      if (action.serviceType === ServiceType.PROJECT) {
        return action.error.toString()
      }
      return state
    default:
      return state
  }
}

const curRangeEnd = (state = '', action) => {
  switch (action.type) {
    case SET_CUR_TIME_RANGE:
      if (action.reducerKey !== PROJECT_INFO_REDUCER_KEY) {
        return state
      }
      return action.endTime
    default:
      return state
  }
}

const curRangeType = (state = RangeType.LAST_WEEK, action) => {
  switch (action.type) {
    case SET_CUR_TIME_RANGE:
      if (action.reducerKey !== PROJECT_INFO_REDUCER_KEY) {
        return state
      }
      return action.rangeType
    default:
      return state
  }
}

const curBucketId = (state = '', action) => {
  switch (action.type) {
    case SET_CUR_BUCKET_ID:
      if (action.reducerKey !== PROJECT_INFO_REDUCER_KEY) {
        return state
      }
      return action.bucketId
    default:
      return state
  }
}

const curBucketType = (state = BucketType.DAY, action) => {
  switch (action.type) {
    case SET_CUR_BUCKET_TYPE:
      if (action.reducerKey !== PROJECT_INFO_REDUCER_KEY) {
        return state
      }
      return action.bucketType
    default:
      return state
  }
}

const curValidBucketTypes = (state = [BucketType.DAY], action) => {
  switch (action.type) {
    case SET_CUR_TIME_RANGE:
      if (action.reducerKey !== PROJECT_INFO_REDUCER_KEY) {
        return state
      }
      if (action.rangeType === RangeType.LAST_DAY) {
        return [BucketType.DAY]
      } else if (action.rangeType === RangeType.LAST_WEEK) {
        return [BucketType.DAY, BucketType.WEEK]
      } else if (action.rangeType === RangeType.LAST_MONTH) {
        return [BucketType.DAY, BucketType.WEEK, BucketType.MONTH]
      }
      return [BucketType.WEEK, BucketType.MONTH, BucketType.YEAR]
    default:
      return state
  }
}

const curServiceIds = (state = [], action) => {
  switch (action.type) {
    case SET_CUR_SERVICE_IDS:
      if (action.reducerKey !== PROJECT_INFO_REDUCER_KEY) {
        return state
      }
      return action.serviceIds
    default:
      return state
  }
}

const curMetricIds = (state = [], action) => {
  switch (action.type) {
    case SET_CUR_METRIC_IDS:
      if (action.reducerKey !== PROJECT_INFO_REDUCER_KEY) {
        return state
      }
      return action.metricIds
    default:
      return state
  }
}

export default combineReducers({
  loading,
  error,
  curServiceIds,
  curMetricIds,
  curRangeEnd,
  curRangeType,
  curBucketId,
  curBucketType,
  curValidBucketTypes
})
