import DefaultLayout from 'layouts/DefaultLayout'
import { injectReducer } from 'store/reducers'
import TeamInfo from './routes/TeamInfo'

const route = (store) => ({
  getComponent (nextState, next) {
    require.ensure([], (require) => {
      const component = require('./containers/TeamList').default
      const reducer = require('./reducers/team_list').default
      injectReducer(store, {
        key: 'team_list',
        reducer: reducer
      })
      next(null, component)
    })
  }
})

export default (store) => ({
  path: 'teams',
  component   : DefaultLayout,
  indexRoute  : route(store),
  childRoutes: [
    TeamInfo(store)
  ]
})
