import React from 'react'
import ServiceInfo from 'routes/Services/components/ServiceInfo'
import ServiceListEntry from 'routes/Services/components/ServiceListEntry'
import ServiceGraph from 'containers/ServiceGraph'
import { Grid } from 'react-bootstrap'
import { TEAM_GRAPH_REDUCER_KEY } from '../reducers/team_graph'
import UrlUtils from 'utils/UrlUtils'

export default class TeamInfo extends ServiceInfo {

  componentWillReceiveProps (nextProps) {
    if (nextProps.selectedTab === 'metrics') {
      this.setActiveTabIdx('1')
    }
  }

  setActiveTab (tabKey) {
    if (tabKey === '1') {
      UrlUtils.updateUrl(UrlUtils.getServiceMetricsUrl(this.props.serviceId, this.props.serviceType))
    } else {
      UrlUtils.updateUrl(UrlUtils.getServiceUrl(this.props.serviceId, this.props.serviceType))
    }
    super.setActiveTab(tabKey)
  }

  renderTabs () {
    const service = this.props.services[this.props.serviceId]
    return [
      ['Projects', this.renderProjects(service)],
      ['Metrics', this.renderMetrics(service)]
    ]
  }

  renderProjects (service) {
    let projects = []
    service.children.forEach((serviceId, idx) => {
      projects.push(<ServiceListEntry key={idx} serviceId={serviceId} services={this.props.services} hideParent />)
    })

    return (
      <Grid style={{ marginTop: '40px' }} fluid>
        <h1 style={{ marginTop: '0px' }}>There are {projects.length} projects within this team.</h1>
        <hr />
        {projects}
      </Grid>
    )
  }

  renderMetrics (service) {
    return (
      <Grid style={{ marginTop: '40px' }} fluid>
        <ServiceGraph
          reducerKey={TEAM_GRAPH_REDUCER_KEY}
          serviceId={this.props.serviceId}
          metricIds={this.props.metricIds}
          options={{ responsive: true }}
          showControls
          urlStr={UrlUtils.getServiceMetricsUrl(this.props.serviceId, this.props.serviceType)}
        />
      </Grid>
    )
  }
}
