import { connect } from 'react-redux'
import TeamInfo from '../components/TeamInfo'
import { ServiceType } from 'modules/api_data/types'
import { TEAM_GRAPH_REDUCER_KEY } from '../reducers/team_graph'

const mapStateToProps = (state, ownProps) => {
  const error = state.team_info.error
  const loading = state.team_info.loading
  const serviceId = ownProps.params.teamId

  return {
    error,
    loading,
    serviceId,
    serviceType: ServiceType.TEAM,
    services: state.api_data.services,
    metrics: state.api_data.metrics,
    metricIds: state.api_data.metricIds,
    reducerKeys: [TEAM_GRAPH_REDUCER_KEY],
    selectedTab: ownProps.params.selectedTab
  }
}

export default connect(mapStateToProps)(TeamInfo)
