import { injectReducer } from 'store/reducers'

export default (store) => ({
  path: ':teamId(/:selectedTab)',
  getComponent (nextState, next) {
    require.ensure([], (require) => {
      const component = require('./containers/TeamInfo').default
      let reducer = require('./reducers/team_info').default
      injectReducer(store, {
        key: 'team_info',
        reducer: reducer
      })
      reducer = require('./reducers/team_graph').default
      injectReducer(store, {
        key: 'team_graph',
        reducer: reducer
      })
      next(null, component)
    })
  }
})
