import { combineReducers } from 'redux'
import { BucketType, RangeType } from 'modules/api_data/types'
import {
  SET_CUR_SERVICE_IDS,
  SET_CUR_METRIC_IDS,
  SET_CUR_BUCKET_ID,
  SET_CUR_BUCKET_TYPE,
  SET_CUR_TIME_RANGE,
  REQUEST_METRICS_DATA,
  RECEIVE_METRICS_DATA,
  RECEIVE_METRICS_DATA_ERROR
} from 'modules/metrics_data/actions'

export const TEAM_GRAPH_REDUCER_KEY = 'team_graph'

const loading = (state = true, action) => {
  switch (action.type) {
    case REQUEST_METRICS_DATA:
      if (action.reducerKey === TEAM_GRAPH_REDUCER_KEY) {
        return true
      }
      return state
    case RECEIVE_METRICS_DATA:
    case RECEIVE_METRICS_DATA_ERROR:
      if (action.reducerKey === TEAM_GRAPH_REDUCER_KEY) {
        return false
      }
      return state
    default:
      return state
  }
}

const curRangeEnd = (state = '', action) => {
  switch (action.type) {
    case SET_CUR_TIME_RANGE:
      if (action.reducerKey !== TEAM_GRAPH_REDUCER_KEY) {
        return state
      }
      return action.endTime
    default:
      return state
  }
}

const curRangeType = (state = RangeType.LAST_WEEK, action) => {
  switch (action.type) {
    case SET_CUR_TIME_RANGE:
      if (action.reducerKey !== TEAM_GRAPH_REDUCER_KEY) {
        return state
      }
      return action.rangeType
    default:
      return state
  }
}

const curBucketId = (state = '', action) => {
  switch (action.type) {
    case SET_CUR_BUCKET_ID:
      if (action.reducerKey !== TEAM_GRAPH_REDUCER_KEY) {
        return state
      }
      return action.bucketId
    default:
      return state
  }
}

const curBucketType = (state = BucketType.DAY, action) => {
  switch (action.type) {
    case SET_CUR_BUCKET_TYPE:
      if (action.reducerKey !== TEAM_GRAPH_REDUCER_KEY) {
        return state
      }
      return action.bucketType
    default:
      return state
  }
}

const curValidBucketTypes = (state = [BucketType.DAY], action) => {
  switch (action.type) {
    case SET_CUR_TIME_RANGE:
      if (action.reducerKey !== TEAM_GRAPH_REDUCER_KEY) {
        return state
      }
      if (action.rangeType === RangeType.LAST_DAY) {
        return [BucketType.DAY]
      } else if (action.rangeType === RangeType.LAST_WEEK) {
        return [BucketType.DAY, BucketType.WEEK]
      } else if (action.rangeType === RangeType.LAST_MONTH) {
        return [BucketType.DAY, BucketType.WEEK, BucketType.MONTH]
      }
      return [BucketType.WEEK, BucketType.MONTH, BucketType.YEAR]
    default:
      return state
  }
}

const curServiceIds = (state = [], action) => {
  switch (action.type) {
    case SET_CUR_SERVICE_IDS:
      if (action.reducerKey !== TEAM_GRAPH_REDUCER_KEY) {
        return state
      }
      return action.serviceIds
    default:
      return state
  }
}

const curMetricIds = (state = [], action) => {
  switch (action.type) {
    case SET_CUR_METRIC_IDS:
      if (action.reducerKey !== TEAM_GRAPH_REDUCER_KEY) {
        return state
      }
      return action.metricIds
    default:
      return state
  }
}

export default combineReducers({
  loading,
  curBucketId,
  curBucketType,
  curValidBucketTypes,
  curRangeEnd,
  curRangeType,
  curServiceIds,
  curMetricIds
})
