// We only need to import the modules necessary for initial render
import CoreLayout from 'layouts/CoreLayout'
import Home from './Home'
import Metrics from './Metrics'
import Projects from './Services/routes/Projects'
import Teams from './Services/routes/Teams'
import Orgs from './Services/routes/Orgs'
import Enroll from './Enroll'
import Error404 from './Error404'

export default (store) => ({
  path        : '/',
  component   : CoreLayout,
  indexRoute  : Home,
  childRoutes : [
    Metrics(store),
    Enroll(store),
    Projects(store),
    Teams(store),
    Orgs(store),
    Error404(store) // This must be at the bottom, for its route is a catch-all.
  ]
})

/*  Note: childRoutes can be chunked or otherwise loaded programmatically
    using getChildRoutes with the following signature:

    getChildRoutes (location, cb) {
      require.ensure([], (require) => {
        cb(null, [
          // Remove imports!
          require('./Counter').default(store)
        ])
      })
    }

    However, this is not necessary for code-splitting! It simply provides
    an API for async route definitions. Your code splitting should occur
    inside the route `getComponent` function, since it is only invoked
    when the route exists and matches.
*/
