export default class UrlUtils {

  static getServiceUrl (serviceId, serviceType) {
    return `/${serviceType.name.toLowerCase()}s/${serviceId}`
  }

  static getMetricsUrl (rangeType, bucketType) {
    let url = '/metrics'
    if (bucketType !== undefined && rangeType !== undefined) {
      url += `?bucketType=${bucketType.name}&rangeType=${rangeType.name}`
    }
    return url
  }

  static getServiceMetricsUrl (serviceId, serviceType, rangeType, bucketType) {
    let url = UrlUtils.getServiceUrl(serviceId, serviceType)
    url += UrlUtils.getMetricsUrl(rangeType, bucketType)
    return url
  }

  static updateUrl (path) {
    if (encodeURI(path) !== window.location.pathname) {
      const newUrl = window.location.origin + path
      window.history.pushState({ path:newUrl }, '', newUrl)
    }
  }
}
