import { ServiceType } from 'modules/api_data/types'

export default class Utils {
  static getElaspedTimeStr (timeA, timeB = new Date()) {
    let timeDiff = timeB.getTime() - timeA.getTime()

    // Strip the ms
    timeDiff /= 1000

    // Get the seconds and remove them.
    var seconds = Math.round(timeDiff % 60)
    timeDiff = Math.floor(timeDiff / 60)

    // Get the minutes and remove them.
    var minutes = Math.round(timeDiff % 60)
    timeDiff = Math.floor(timeDiff / 60)

    // Get the hours and remove them.
    var hours = Math.round(timeDiff % 24)
    timeDiff = Math.floor(timeDiff / 24)

    // Remaining is the number of days.
    var days = timeDiff

    let value = 0
    let unitStr = ''
    if (days > 0) {
      value = days
      unitStr = 'days'
    } else if (hours > 0) {
      value = hours
      unitStr = 'hours'
    } else if (minutes > 0) {
      value = minutes
      unitStr = 'minutes'
    } else if (seconds > 0) {
      value = minutes
      unitStr = 'seconds'
    }
    if (value === 0) {
      return undefined
    } else if (value === 1) {
      value = 'a'
      unitStr = unitStr.slice(0, -1)
    }
    return `${value.toLocaleString()} ${unitStr}`
  }

  static isObjectEmpty (obj) {
    return (Object.keys(obj).length === 0 && obj.constructor === Object)
  }

  static getTitleCase (str) {
    return str.replace(/\w\S*/g, function (txt) { return txt.charAt(0).toUpperCase() + txt.substr(1).toLowerCase() })
  }

  static getPluralOfServiceType (serviceType) {
    if (serviceType === ServiceType.ORG) {
      return `organizations`
    }
    return `${serviceType.name.toLowerCase()}s`
  }
}
