import React from 'react'
import DocumentTitle from 'react-document-title'
import ErrorAlert from 'components/ErrorAlert'
import { Grid } from 'react-bootstrap'

export default class DefaultView extends React.Component {

  errorTitle () {
    return 'Error'
  }

  documentTitle () {
    return 'RPS | Document'
  }

  renderError () {
    return (
      <ErrorAlert
        header={this.errorTitle()}
        message={this.props.error}
      />
    )
  }

  render () {
    let content = null
    if (this.props.error !== null && this.props.error !== undefined) {
      content = (
        <Grid style={{ marginTop: '40px' }}>
          {this.renderError()}
        </Grid>
      )
    } else if (this.props.loading) {
      content = (
        <Grid style={{ marginTop: '40px' }}>
          <div>Loading...</div>
        </Grid>
      )
    } else {
      content = this.renderContent()
    }
    return (
      <DocumentTitle title={this.documentTitle()}>
        {content}
      </DocumentTitle>
    )
  }
}

DefaultView.propTypes = {
  error: React.PropTypes.any,
  loading: React.PropTypes.bool
}
