import React from 'react'
import DefaultView from '../DefaultView'
import {
  Grid,
  Row,
  Col,
  Tab,
  Nav,
  NavItem
} from 'react-bootstrap'
import './TabsView.scss'

export default class TabsView extends DefaultView {

  constructor (props) {
    super(props)
    this.state = {
      tabActiveKey: '0'
    }
  }

  setActiveTab (tabKey) {
    this.setActiveTabIdx(tabKey)
  }

  setActiveTabIdx (tabKey) {
    this.setState({ tabActiveKey: tabKey })
  }

  renderHeader () {
    return (
      <div>
        Preface
      </div>
    )
  }

  renderTabs () {
    return [
      ['Tab 1', <div>Tab 1</div>]
    ]
  }

  renderContent () {
    const tabsData = this.renderTabs()
    let tabs = []
    let tabsContent = []
    tabsData.forEach((tabData, idx) => {
      tabs.push(<NavItem key={`${idx}`} eventKey={`${idx}`}>{tabData[0]}</NavItem>)
      tabsContent.push(<Tab.Pane key={`${idx}`} eventKey={`${idx}`}>{tabData[1]}</Tab.Pane>)
    })

    return (
      <div>
        <Grid className='tabs-view-header' fluid>
          <Grid>
            {this.renderHeader()}
          </Grid>
        </Grid>
        <Grid className='tabs-view-container'>
          <Tab.Container
            id='tabs-view-tabs'
            activeKey={this.state.tabActiveKey}
            onSelect={(key) => { this.setActiveTab(key) }}
          >
            <Row className='clearfix'>
              <Col sm={12}>
                <Nav bsStyle='tabs'>
                  {tabs}
                </Nav>
              </Col>
              <Col sm={12}>
                <Tab.Content animation>
                  {tabsContent}
                </Tab.Content>
              </Col>
            </Row>
          </Tab.Container>
        </Grid>
      </div>
    )
  }
}
