export default class ConsoleWatcher {

  constructor () {
    // Hash of console entries that we modified.  Each key is an entry mapped to a boolean indicating if it was
    // modified.  We use this in our destructor to determine if the console needs to be reset.
    this.modified = {
      error: false
    }
  }

  /**
   * React will console.error propType errors and other issues.  This function will throw them as actual errors via
   * sinon.js so that our test can catch them and test for them accordingly.
   */
  watchForErrors () {
    this.modified.error = true
    sinon.stub(console, 'error', (warning) => { throw new Error(warning) })
  }

  /**
   * Use this to restore the console.error if stubs or anything were applied to it during testing.  Would often want to
   * call this in after() or afterEach().
   */
  restore () {
    if (this.modified.error) {
      console.error.restore()
      this.modified.error = false
    }
  }
}
