package main

import (
	"io/ioutil"
	"log"
	"os"
	"time"

	"code.justin.tv/common/config"
	"code.justin.tv/dta/rockpaperscissors/client/eventpublisher"
)

func init() {
	config.Register(map[string]string{
		"type": "",
		"body": "",
	})
}

func main() {
	// To add app-specific config flags, you can call config.Register()
	// https://godoc.internal.justin.tv/code.justin.tv/common/config
	err := config.Parse()
	if err != nil {
		log.Fatal(err)
	}

	eventType := config.MustResolve("type")
	body := config.MustResolve("body")

	var bodyBytes []byte
	if body == "-" {
		bodyBytes, err = ioutil.ReadAll(os.Stdin)
		if err != nil {
			log.Fatal(err)
		}
	} else {
		bodyBytes = []byte(body)
	}

	publisher, err := eventpublisher.NewEventPublisher(config.App(),
		&eventpublisher.Config{Environment: eventpublisher.DEVELOPMENT})
	if err != nil {
		log.Fatal(err)
	}

	event, err := eventpublisher.CreateEvent(time.Now(), eventType, bodyBytes, nil)
	if err != nil {
		log.Fatal(err)
	}

	err = publisher.PublishEvent(event)
	if err != nil {
		log.Fatal(err)
	}

	log.Print("Successfully published event")
}
