package main

import (
	"errors"
	"fmt"

	"github.com/urfave/cli"

	"code.justin.tv/dta/rockpaperscissors/client/blueprint"
)

func init() {
	cmd := cli.Command{
		Name:  "blueprints",
		Usage: "commands related to blueprint files",
		Subcommands: []cli.Command{
			{
				Name:      "validate",
				Usage:     "validate a text-formatted protobuf file",
				ArgsUsage: "FILE",
				Action:    validateBlueprintAction,
			},
		},
	}
	app.Commands = append(app.Commands, cmd)
}

func validateBlueprintAction(c *cli.Context) error {
	protoFilename := c.Args().Get(0)
	if len(protoFilename) == 0 {
		return errors.New(
			"filename for a text-formated ProjectMetadata protobuf is required")
	}
	_, err := blueprint.ReadFile(protoFilename)
	if err != nil {
		return err
	}
	fmt.Println("Blueprint is valid.")
	return nil
}
