# Event Types

## GitHub-deployment_status

This is created and published by an AWS Lambda function that receives GitHub
webhook requests from GitHub.

| Type:       | GitHub-deployment_status                                           |
|-------------|--------------------------------------------------------------------|
| Body:       | A gzip compressed [GitHub DeploymentStatusEvent JSON](https://developer.github.com/enterprise/2.9/v3/activity/events/types/#deploymentstatusevent) |
| Attributes: | github_repository=https://host/owner/repos                         |
|             | deployment_state=see documentation for deployment_status state key |
|             | creator=username                                                   |

## GitHub-pull_request-*

This is created and published by an AWS Lambda function that receives GitHub
webhook requests from GitHub. This is actually a family of event types. The
type is suffixed with the pull request action (e.g. "opened", "closed"). See
the GitHub PullRequestEvent documentation for the full list (linked below).

| Type:       | GitHub-pull_request-*                              |
|-------------|----------------------------------------------------|
| Body:       | A gzip compressed [GitHub PullRequestEvent JSON](https://developer.github.com/enterprise/2.9/v3/activity/events/types/#pullrequestevent) |
| Attributes: | head_repository=https://host/owner/repos           |
|             | head_ref=git ref (branch name, tag, or commit ID)  |
|             | base_repository=https://host/owner/repos           |
|             | base_ref=git ref (branch name, tag, or commit ID)  |
|             | user=username                                      |

## GitHub-push

This is created and published by an AWS Lambda function that receives GitHub
webhook requests from GitHub.

| Type:       | GitHub-push                                |
|-------------|--------------------------------------------|
| Body:       | [GitHub PushEvent JSON](https://developer.github.com/enterprise/2.9/v3/activity/events/types/#pushevent) |
| Attributes: | github_repository=https://host/owner/repos |
|             | pusher=username                            |
|             | branch=branchname                          |

## GitHub-Stats

This is created inside rockpaperscissors server in response to `GitHub-push`
events. It's stored directly into the datastore, not published to the event bus.

| Type:       | GitHub-Stats                               |
|-------------|--------------------------------------------|
| Body:       | [GitHubStatsEvent protobuffer](https://git-aws.internal.justin.tv/dta/rockpaperscissors/blob/master/proto/events/github_stats.proto) |
| Attributes: | github_repository=https://host/owner/repos |
|             | author=username                            |
|             | committer=username                         |

## JIRAScraperEvent

This is created and published by an AWS Lambda function that runs every hour.
It queries JIRA for production incidents and bugs.

| Type:       | JIRAScraperEvent             |
|-------------|------------------------------|
| Body:       | [JIRAScraperEvent protobuffer](https://git-aws.internal.justin.tv/dta/rockpaperscissors/blob/master/proto/events/jira_scraper.proto) |
| Attributes: | none                         |

## JenkinsBuildStats

This is created and published by the `rockpaperscissors-jenkins` Jenkins plugin.
As a post-build action for every Jenkins build, some metadata from the build is
collected and a `JenkinsBuildStats` protobuffer is filled in and published.

| Type:       | JenkinsTestResults                         |
|-------------|--------------------------------------------|
| Body:       | [JenkinsBuildStats protobuffer](https://git-aws.internal.justin.tv/dta/rockpaperscissors/blob/master/proto/events/jenkins_build.proto) |
| Attributes: | github_repository=https://host/owner/repos |
|             | github_branch=branchname                   |
|             | jenkins_job_name=jenkins-job-build         |

## JenkinsTestResults

This is created and published by the `rockpaperscissors-jenkins` Jenkins plugin.
As a post-build action for every Jenkins build, if that build has an archived
artifact named `test_report.xml`, then it will be collected and published as an
event.

| Type:       | JenkinsTestResults                                                                       |
|-------------|------------------------------------------------------------------------------------------|
| Body:       | [test_report.xml](https://twitchtv.atlassian.net/wiki/display/QE/Reporting+Test+Results) |
| Attributes: | github_repository=https://host/owner/repos                                               |
|             | github_branch=branchname                                                                 |
|             | jenkins_job_name=jenkins-job-build                                                       |

## JenkinsTestCoverage

This is created and published by the `rockpaperscissors-jenkins` Jenkins plugin.
As a post-build action for every Jenkins build, if that build has an archived
artifact named `coverage.xml` or `codecov_coverage.json`, then it will be collected
and published as an event.

| Type:       | JenkinsTestCoverage                                                                            |
|-------------|------------------------------------------------------------------------------------------------|
| Body:       | [See QE Coverage docs](https://twitchtv.atlassian.net/wiki/display/QE/Reporting+Code+Coverage+Results) |
| Attributes: | github_repository=https://host/owner/repos                                                     |
|             | github_branch=branchname                                                                       |
|             | jenkins_job_name=jenkins-job-build                                                             |
|             | coverage_file="codecov_coverage.json" or "coverage.xml"                                        |
