# rockpaperscissors Flags and Environment Varibles

The `rockpaperscissors` service binary uses [common/config](https://git-aws.internal.justin.tv/common/config) to handle
command line arguments and environment variables.

For each flag, the package also looks for an environment variable that has a name that is the flag with the leading
hyphen dropped, the remaining transformed to underscores, and the rest of the name uppercased. For example,
`-bind-address` becomes `BIND_ADDRESS`.

The command line flags are very useful for local testing during development. For the most part, the defaults are
designed to run against the "development" resources so you don't accidentally affect the production datastores.

Effectively, configuration management is done via environment variables set on the Beanstalk environment.
For running under Elastic Beanstalk, it's very conveninent that the service binary looks for environment variables.
Those environment variables can be configured for each Beanstalk environment through Terraform and can also be
tweaked using the AWS console. Changing the command line flags is much more work by comparison and requires a change
to the application version package. 

If you run the binary with the `-h` flag, it will print out a simple usage statement:

```
Usage of ./rockpaperscissors:
  -app string
    	 (default "rockpaperscissors")
  -bind-address string
    	 (default ":8000")
  -debug-bind-address string
    	 (default ":6000")
  -disabled-metrics string
    	
  -enable-events-datastore-writes string
    	 (default "true")
  -enable-ingest-queue-consumer string
    	 (default "true")
  -enable-projects-datastore-writes string
    	 (default "true")
  -environment string
    	 (default "development")
  -events-table-name string
    	 (default "rockpaperscissors-development-events")
  -grpc-request-log string
    	
  -grpc-request-log-format string
    	 (default "text")
  -http-access-log string
    	
  -ingest-queue-name string
    	 (default "rockpaperscissors-development-ingest")
  -memcached-config-endpoint string
    	
  -memcached-timeout-ms string
    	 (default "1000")
  -projects-table-name string
    	 (default "rockpaperscissors-development-projects")
  -rollbar-token string
    	
  -sandstorm-role-arn string
    	 (default "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/devtools-development-rockpaperscissors")
  -statsd-host-port string
    	 (default "statsd.internal.justin.tv:8125")
```

| Flag                              | Env Var                          | Default                                | Description                                                                                                                                                                                                                                          |
|-----------------------------------|----------------------------------|----------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| -app                              | APP                              | rockpaperscissors                      | The name of the service/app as it's reported to Rollbar and statsd.                                                                                                                                                                                  |
| -bind-address                     | BIND_ADDRESS                     | :8000                                  | The IP and port to bind to for the main web interface, REST API endpoint, and gRPC endpoint. Omitting the IP will have it bind to that port on all network interfaces.                                                                               |
| -debug-bind-address               | DEBUG_BIND_ADDRESS               | :6000                                  | The IP and port to bind to for the debug information endpoint. Omitting the IP will have it bind to that port on all network interfaces.                                                                                                             |
| -disabled-metrics                 | DISABLED_METRICS                 |                                        | A comma separated list of metric names to disable. These metrics won't be listed as available through the metrics API, can't be queried for, and won't list in the web client. This is to disable metrics that may have a bug or performance issues. |
| -enable-events-datastore-writes   | ENABLE_EVENTS_DATASTORE_WRITES   | true                                   | Disables the write path for the events API. Used for testing so you don't accidentally change the events datastore.                                                                                                                                  |
| -enable-ingest-queue-consumer     | ENABLE_INGEST_QUEUE_CONSUMER     | true                                   | Disables the background routine that polls the "ingest" SQS queue and processes requests it finds there.                                                                                                                                             |
| -enable-projects-datastore-writes | ENABLE_PROJECTS_DATASTORE_WRITES | true                                   | Disables the write path for the project metadata API. Used for testing so you don't accidentally change the projects datastore.                                                                                                                      |
| -environment                      | ENVIRONMENT                      | development                            | The name of the environment the app/service is running in. This is reported to Rollbar and Statsd.                                                                                                                                                   |
| -events-table-name                | EVENTS_TABLE_NAME                | rockpaperscissors-development-events   | The name of the AWS DynamoDB table used for the events datastore.                                                                                                                                                                                    |
| -grpc-request-log                 | GRPC_REQUEST_LOG                 |                                        | Name of file to log gRPC requests. If the name is "-", then log entries will be written to standard output.                                                                                                                                          |
| -grpc-request-log-format          | GRPC_REQUEST_LOG_FORMAT          | text                                   | Format of the gRPC log entries. May be "text" or "json".                                                                                                                                                                                             |
| -http-access-log                  | HTTP_ACCESS_LOG                  |                                        | Name of file to log "http access" formatted entries of HTTP requests to the main port. If the name is "-", then log entries will be written to standard output.                                                                                      |
| -ingest-queue-name                | INGEST_QUEUE_NAME                | rockpaperscissors-development-ingest   | The name of the AWS SQS queue used for requests for extra ingest actions such as generating GitHub commit stats.                                                                                                                                     |
| -memcached-config-endpoint        | MEMCACHED_CONFIG_ENDPOINT        |                                        | The host/IP of an AWS ElastiCache memcache config endpoint. The AWS ElastiCache autodiscovery system will be used to get a list of the memcached endpoints in the cluster.                                                                           |
| -memcached-timeout-ms             | MEMCACHED_TIMEOUT_MS             | 1000                                   | Timeout, in milliseconds, for connections to the memcached service.                                                                                                                                                                                  |
| -projects-table-name              | PROJECTS_TABLE_NAME              | rockpaperscissors-development-projects | The name of the AWS DynamoDB table used for the project metadata datastore.                                                                                                                                                                          |
| -rollbar-token                    | ROLLBAR_TOKEN                    |                                        | Rollbar API token used to report runtime panics.                                                                                                                                                                                                     |
| -sandstorm-role-arn               | SANDSTORM_ROLE_ARN               | (see usage output)                     | This is the ARN of the AWS role that will be used to access secrets in Sandstorm. The current AWS user/role must be able to AssumeRole to the given role.                                                                                            |
| -statsd-host-port                 | STATSD_HOST_PORT                 | statsd.internal.justin.tv:8125         | The host/port to which go stats should be reported (memory usage, etc).                                                                                                                                                                              |
