# rpstool Cookbook #

`rpstool` exposes almost all of the RockPaperScissors APIs to the command line.
The combination is very powerful for doing ad hoc queries.

By default, `rpstool` talks to the production instance at
`rockpaperscissors.internal.justin.tv:80` but you can change that with either
the `--rps-addr` flag or by setting the `RPS_ADDR` environment variable. The
development instance at `rockpaperscissors-dev.internal.justin.tv:80` is good
if you'd like to experiment.

`rpstool` has many subcommands and built-in help. Try running it without any
arguments to get the basic subcommands and usage of the `help` command.

Different types of events have different formats for their bodies. Often, the
body is a protobuffer which can be decoded with the `protoc` tool
(installable using `brew`). Different types of events have different attributes
which you can query on.

[Documentation on event formats and attributes](events.md)

## How many builds in Jenkins have we had in the past 24 hours? ##

A `JenkinsBuildStats` event is generated every time there is a build in Jenkins.

```shell
rpstool events query --type JenkinsBuildStats --period 24h | grep ^UUID | wc -l
```

## What are the top 20 most run Jenkins jobs in the past 24 hours? ##

```shell
rpstool events query --type JenkinsBuildStats --period 24h | grep jenkins_job_name | sort | uniq -c | sort -n -r | head -20
```

## Which jobs in Jenkins are collecting test results complying with QE standards? ##

This one does a query for the past 30 days because not every job is run every
day.

```shell
rpstool events query --type JenkinsTestResults --period 720h | grep jenkins_job_name | sort | uniq
```

## Decode the event body of a JenkinsBuildStats event ##

For this, you'll need to install the
[Google Protobuffer](https://developers.google.com/protocol-buffers/) compiler
(`brew install protobuf` if you use Homebrew on macOS or
[from their github](https://github.com/google/protobuf)). You will also need
to have the `.proto` files from this repository. The protoc tool is a bit
sensitive to path names. If you have the `go` compiler installed, it's easiest
if you just `go get -u code.justin.tv/dta/rockpaperscissors` and then you can
run:

```shell
rpstool events get VCdTA9hbT4G0VYvdO8xC1w== --body-only | protoc --decode=rockpaperscissors.events.JenkinsBuildStats -I $GOPATH/src $GOPATH/src/code.justin.tv/dta/rockpaperscissors/proto/events/jenkins_build.proto
```
