rpstool Usage Tracking and Crash Reporting
==========================================

## Usage Tracking

In order to help support `rpstool` users, command line usage is reported into
AWS Mobile Analytics which will show us usage metrics such as:

* what platforms it's being used on
* how many active users we have
* how many new users we have
* what versions are being used
* what command line parameters are they using
* errors being thrown

Mobile Analytics has a service called "Cognito" which allows unauthenticated
access to AWS as long as the requestor knows the identity app ID. Access the
user has to AWS is limited to just adding events to Mobile Analytics. This
ID is embedded into the `rpstool` binary and exposed in the `rpstool` source
code. This isn't a sensitive key.

The worse case scenarios are that someone uses it to pollute the analytics or
waste money by creating tons of events.

The current console showing several graphs is available in the
[`twitch-core-services` AWS account](https://console.aws.amazon.com/mobileanalytics/home/#/overview?consoleState=reports&appId=a2e882c6c3f34f4b89f12a50e6a063fa).

The usage data is also being automatically exported from Mobile Analytics into
a Redshift database for ad hoc querying.

## Crash Reporting

Regular errors are being reported into Mobile Analytics. These include
resources being unavailable, misconfiguration, or user errors. We will depend
on users reporting bugs or getting support from the team for these.

A panic in the Go code, however, is an exceptional event, shouldn't happen,
and indicates a bug in the code of `rpstool`.

When a panic occurs, it will be reported into
[Rollbar](https://rollbar.com/Twitch/RockPaperScissors/) with:

* `rpstool` version
* error
* stack trace

Rollbar will automatically escalate the issue to the
[RockPaperScissors service in PagerDuty](https://twitchoncall.pagerduty.com/services/PFZ9QJ2)
and the current on-call will be notified (in addition to an alert going into
the #rps Slack channel).

Similar to AWS Mobile Analytics, Rollbar has an access token which is baked
into `rpstool` and exposed in the source code. It's not a sensitive key and,
worse case, someone could use it to make annoying reports. There is a rate
limit on the key to prevent someone from using it to waste money.
