#!/bin/bash

set -e

function abspath()
{
  (cd $1 && pwd)
}

# Generate *_service.swagger.json files for the RESTful interface.
protoc -I/usr/local/include -I. \
  -I$GOPATH/src \
  -I$(abspath ../../../vendor/github.com/grpc-ecosystem/grpc-gateway/third_party/googleapis) \
  --swagger_out=logtostderr=true:. \
  $(abspath ../../../proto)/*_service.proto

# Move the swgger files out of the tree created based on the proto package.
mv ./code.justin.tv/dta/rockpaperscissors/proto/* .
rm -rf ./code.justin.tv

# Package the swagger spec files and swagger-ui into compiled-in assets for serving.
# bindata_assetfs.go will be generated in this Go package.
go-bindata-assetfs -pkg swagger -ignore="\\.(go|sh)" -prefix $(abspath ../..) $(pwd)/...
