package codecov

import (
	"io/ioutil"
	"testing"

	"code.justin.tv/dta/rockpaperscissors/internal/testutil"
)

func TestUnMarshal(t *testing.T) {
	reportJSON, err := ioutil.ReadFile("codecov_coverage.json")
	if err != nil {
		t.Fatal(err)
	}

	coverageReport, err := Unmarshal(reportJSON)
	testutil.AssertNil(t, "Unmarshal returned a nil error", err)
	testutil.AssertEquals(t, "CoverageRatio unmarshaling",
		coverageReport.Commit.Totals.CoverageRatio, 22.06633)
}
