package github

//go:generate mockgen -destination ../mocks/mock_sandstorm/mock_sandstorm.go -source ../sandstorm/sandstorm.go

import (
	"testing"

	"code.justin.tv/dta/rockpaperscissors/internal/mocks/mock_sandstorm"

	"code.justin.tv/dta/rockpaperscissors/internal/testutil"
	"code.justin.tv/systems/sandstorm/manager"
	"github.com/golang/mock/gomock"
)

func TestClient(t *testing.T) {
	mockCtrl := gomock.NewController(t)
	defer mockCtrl.Finish()

	mockSandstormClient := mock_sandstorm.NewMockClientIface(mockCtrl)

	secret := &manager.Secret{
		Plaintext: []byte("plaintext"),
	}

	// Assert that the correct secret was used.
	mockSandstormClient.EXPECT().Get(
		"rps/rockpaperscissors/development/github-oauth-token").Return(
		secret, nil)

	client, err := Client(mockSandstormClient, "github.example.com")

	// Assert the client fields are configured correctly.
	testutil.AssertNil(t, "Client returned a nil error", err)
	testutil.AssertEquals(t, "Client UserAgent",
		client.UserAgent, "_test-development")
	testutil.AssertEquals(t, "Client UserAgent",
		client.BaseURL.String(), "https://github.example.com/api/v3/")
}
