package ingestqueueconsumer

import (
	"context"

	xnetcontext "golang.org/x/net/context"
	"google.golang.org/grpc"

	pb "code.justin.tv/dta/rockpaperscissors/proto"
)

type projectMetdataServiceIface interface {
	IngestBlueprint(xnetcontext.Context, *pb.IngestBlueprintRequest, ...grpc.CallOption) (*pb.IngestBlueprintResponse, error)
}

// BlueprintIngestor handles IngestBlueprintRequests to update project metadata from blueprint changes.
type BlueprintIngestor struct {
	projectMetdataClient projectMetdataServiceIface
}

// NewBlueprintIngestor initializes a BlueprintIngestor struct.
func NewBlueprintIngestor(projectMetdataClient projectMetdataServiceIface) *BlueprintIngestor {
	return &BlueprintIngestor{
		projectMetdataClient: projectMetdataClient,
	}
}

// Ingest handles an IngestBlueprintRequest. Forwards the request to the project metadata service.
func (c *BlueprintIngestor) Ingest(ctx context.Context, in *pb.IngestBlueprintRequest) error {
	_, err := c.projectMetdataClient.IngestBlueprint(ctx, in)
	return err
}
