package junit

import "encoding/xml"

// TestSuites is the top level element of JUnit, contains summary and TestSuites.
type TestSuites struct {
	Tests      int         `xml:"tests,attr"`
	Fails      int         `xml:"fails,attr"`
	Errors     int         `xml:"errors,attr"`
	Time       float64     `xml:"time,attr"`
	TestSuites []TestSuite `xml:"testsuite"`
}

// TestSuite contain properties and TestCases.
type TestSuite struct {
	Tests      int        `xml:"tests,attr"`
	Failures   int        `xml:"failures,attr"`
	Time       float64    `xml:"time,attr"`
	Name       string     `xml:"name,attr"`
	TypeType   string     `xml:"testType,attr"`
	Properties []Property `xml:"properties>property"`
	Testcases  []TestCase `xml:"testcase"`
}

// Property are things like the runtime for the TestSuite and the coverage for the test.
// Examples of known properties:
//   go.version
//   coverage.statements.pct
//   browser.fullName
type Property struct {
	Name  string `xml:"name,attr"`
	Value string `xml:"value,attr"`
}

// TestCase is an individual test for a situation.
type TestCase struct {
	ClassName string  `xml:"classname,attr"`
	Name      string  `xml:"name,attr"`
	Time      float64 `xml:"time,attr"`
}

// Unmarshal JUnit XML into Go structs.
func Unmarshal(data []byte) (*TestSuites, error) {
	testSuites := &TestSuites{}
	err := xml.Unmarshal(data, testSuites)
	if err != nil {
		return nil, err
	}
	return testSuites, nil
}
