package junit

import (
	"testing"

	"code.justin.tv/dta/rockpaperscissors/internal/testutil"
)

func TestUnMarshal(t *testing.T) {
	testResultsXML := `<?xml version="1.0" encoding="UTF-8"?>
  <?xml-stylesheet type="text/xsl" href="style.xsl"?>
  <testsuites tests="50" fails="0" errors="0" time="1.070000">
    <testsuite tests="1" failures="0" time="0.026" name="code.justin.tv/dta/rockpaperscissors/client/eventpublisher" testType="UNIT">
      <properties>
        <property name="go.version" value="go1.7.4"/>
        <property name="coverage.statements.pct" value="63.3"/>
      </properties>
      <testcase classname="eventpublisher" name="TestBasic" time="0.000"/>
    </testsuite>
    <testsuite tests="2" failures="0" time="0.065" name="code.justin.tv/dta/rockpaperscissors/cmd/rpstool" testType="UNIT">
      <properties>
        <property name="go.version" value="go1.7.4"/>
        <property name="coverage.statements.pct" value="11.3"/>
      </properties>
      <testcase classname="rpstool" name="TestURLRegex" time="0.000"/>
      <testcase classname="rpstool" name="TestGitCommitFileLocally" time="0.040"/>
      <system-out/>
      <system-err/>
    </testsuite>
  </testsuites>
  `

	_, err := Unmarshal([]byte(testResultsXML))
	testutil.AssertNil(t, "Unmarshal returned a nil error", err)
}
