package testutil

import (
	"bytes"
	"reflect"
	"testing"
)

// AssertEquals fails the test if the actual and expect do not evaluate as equal.
func AssertEquals(t *testing.T, msg string, actual interface{}, expected interface{}) {
	if actual != expected {
		t.Errorf("%s: (Actual: %v, Expected: %v)", msg, actual, expected)
	}
}

// AssertBytesEqual does as AssertEquals but uses bytes.Equal().
func AssertBytesEqual(t *testing.T, msg string, actual []byte, expected []byte) {
	if !bytes.Equal(actual, expected) {
		t.Errorf("%s: (Actual: %v, Expected: %v)", msg, actual, expected)
	}
}

// AssertTrue fails the test if the value isn't true.
func AssertTrue(t *testing.T, msg string, val bool) {
	if !val {
		t.Errorf("%s: not true", msg)
	}
}

// AssertNil fails the test if the value isn't nil. Works with typed nil pointers.
func AssertNil(t *testing.T, msg string, val interface{}) {
	if val != nil && !reflect.ValueOf(val).IsNil() {
		t.Errorf("%s: %v is not nil", msg, val)
	}
}

// AssertNotNil fails the test if the value is nil. Works with typed nil pointers.
func AssertNotNil(t *testing.T, msg string, val interface{}) {
	if val == nil || reflect.ValueOf(val).IsNil() {
		t.Errorf("%s: %v is nil", msg, val)
	}
}
