job {
  name 'dta-rockpaperscissors'
  using 'TEMPLATE-autobuild'

  scm {
    git {
      remote {
        github 'dta/rockpaperscissors', 'ssh', 'git-aws.internal.justin.tv'
        credentials 'git-aws-read-key'
      }
      clean true
    }
  }

  wrappers {
    preBuildCleanup()
    timestamps()
    colorizeOutput(colorMap='xterm')
    credentialsBinding {
      string 'AWS_ACCESS_KEY', 'tw-beanstalk-uploader-access-key'
      string 'AWS_SECRET_KEY', 'tw-beanstalk-uploader-secret-key'
      file('AWS_CONFIG_FILE', 'aws_config')
      file('AWS_UPLOADER_CONFIG_FILE', 'tw_lambda_uploader-aws_config')
    }
    environmentVariables {
      env('ENVIRONMENT', 'development')
    }
  }

  steps {
    shell 'rm -rf .manta/'
    shell 'manta -f build.json'
    shell 'cp .manta/test_report.xml test_report.xml'
    conditionalSteps {
      runner('DontRun')

      condition {
        stringsMatch('\$GIT_BRANCH', 'origin/master', false)
      }

      steps {
        saveLambdaFunction("dta/rockpaperscissors", ".manta/aws_lambda")

        cleanBeanstalkArtifacts('rockpaperscissors')
        createBeanstalkVersion('rockpaperscissors',
        'docker-registry.internal.justin.tv/dta/rockpaperscissors',
        '.',
        'Dockerrun.aws.json.template',
        '.ebextensions',
        'tw-beanstalk-uploader-artifacts')

        downstreamParameterized {
          trigger('dta-rockpaperscissors-deploy') {
            parameters {
              predefinedProp('GIT_COMMIT', "\$GIT_COMMIT")
              predefinedProp('ENVIRONMENT', "\$ENVIRONMENT")
            }
          }
        }
      }
    }
  }

  publishers {
    reportQuality('dta/rockpaperscissors', '.manta', '*.out')
  }
}

job {
  name 'dta-rockpaperscissors-deploy'
  using 'TEMPLATE-deploy-aws'
  concurrentBuild false

  wrappers {
    timestamps()
    colorizeOutput(colorMap='xterm')
    credentialsBinding {
      string 'AWS_ACCESS_KEY', 'tw-beanstalk-uploader-access-key'
      string 'AWS_SECRET_KEY', 'tw-beanstalk-uploader-secret-key'
      file('AWS_CONFIG_FILE', 'aws_config')
      file('AWS_UPLOADER_CONFIG_FILE', 'tw_lambda_uploader-aws_config')
    }
  }

  steps {
    deployLambdaFunction("dta/rockpaperscissors", "rockpaperscissors-\${ENVIRONMENT}")
    deployLambdaFunction("dta/rockpaperscissors", "rockpaperscissors-\${ENVIRONMENT}-github")
    deployLambdaFunction("dta/rockpaperscissors", "rockpaperscissors-\${ENVIRONMENT}-bp")
    deployLambdaFunction("dta/rockpaperscissors", "rockpaperscissors-\${ENVIRONMENT}-jira")
    deployLambdaFunction("dta/rockpaperscissors", "rockpaperscissors-\${ENVIRONMENT}-ghstats")
    deployElasticBeanstalkArtifact('rockpaperscissors', '\${ENVIRONMENT}', "\$GIT_COMMIT")
  }
}
