// Code generated by protoc-gen-go.
// source: code.justin.tv/dta/rockpaperscissors/proto/project_metadata_service.proto
// DO NOT EDIT!

package proto

import proto1 "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import google_protobuf2 "google.golang.org/genproto/protobuf/field_mask"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto1.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// TODO: should we include fields for query filtering?
type ListProjectsRequest struct {
	// If true, also return any "archived" projects.
	IncludeArchived bool `protobuf:"varint,1,opt,name=include_archived,json=includeArchived" json:"include_archived,omitempty"`
}

func (m *ListProjectsRequest) Reset()                    { *m = ListProjectsRequest{} }
func (m *ListProjectsRequest) String() string            { return proto1.CompactTextString(m) }
func (*ListProjectsRequest) ProtoMessage()               {}
func (*ListProjectsRequest) Descriptor() ([]byte, []int) { return fileDescriptor7, []int{0} }

func (m *ListProjectsRequest) GetIncludeArchived() bool {
	if m != nil {
		return m.IncludeArchived
	}
	return false
}

type ListProjectsResponse struct {
	// Only the project_id and project_name fields will be populated in the ProjectMetadata.
	Projects []*ProjectMetadata `protobuf:"bytes,1,rep,name=projects" json:"projects,omitempty"`
}

func (m *ListProjectsResponse) Reset()                    { *m = ListProjectsResponse{} }
func (m *ListProjectsResponse) String() string            { return proto1.CompactTextString(m) }
func (*ListProjectsResponse) ProtoMessage()               {}
func (*ListProjectsResponse) Descriptor() ([]byte, []int) { return fileDescriptor7, []int{1} }

func (m *ListProjectsResponse) GetProjects() []*ProjectMetadata {
	if m != nil {
		return m.Projects
	}
	return nil
}

type GetMetadataRequest struct {
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
}

func (m *GetMetadataRequest) Reset()                    { *m = GetMetadataRequest{} }
func (m *GetMetadataRequest) String() string            { return proto1.CompactTextString(m) }
func (*GetMetadataRequest) ProtoMessage()               {}
func (*GetMetadataRequest) Descriptor() ([]byte, []int) { return fileDescriptor7, []int{2} }

func (m *GetMetadataRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

// TODO: should we include fields for pagination?
// TODO: should we return back a list of unmatched projects_ids?
type GetMetadataResponse struct {
	Project *ProjectMetadata `protobuf:"bytes,1,opt,name=project" json:"project,omitempty"`
}

func (m *GetMetadataResponse) Reset()                    { *m = GetMetadataResponse{} }
func (m *GetMetadataResponse) String() string            { return proto1.CompactTextString(m) }
func (*GetMetadataResponse) ProtoMessage()               {}
func (*GetMetadataResponse) Descriptor() ([]byte, []int) { return fileDescriptor7, []int{3} }

func (m *GetMetadataResponse) GetProject() *ProjectMetadata {
	if m != nil {
		return m.Project
	}
	return nil
}

type UpdateMetadataRequest struct {
	ProjectMetadata *ProjectMetadata `protobuf:"bytes,1,opt,name=project_metadata,json=projectMetadata" json:"project_metadata,omitempty"`
	// If provided, this is the project to apply the update to, used for renames.
	ProjectId string `protobuf:"bytes,2,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// If provided, only update the given fields from the provided metadata.
	Mask *google_protobuf2.FieldMask `protobuf:"bytes,3,opt,name=mask" json:"mask,omitempty"`
}

func (m *UpdateMetadataRequest) Reset()                    { *m = UpdateMetadataRequest{} }
func (m *UpdateMetadataRequest) String() string            { return proto1.CompactTextString(m) }
func (*UpdateMetadataRequest) ProtoMessage()               {}
func (*UpdateMetadataRequest) Descriptor() ([]byte, []int) { return fileDescriptor7, []int{4} }

func (m *UpdateMetadataRequest) GetProjectMetadata() *ProjectMetadata {
	if m != nil {
		return m.ProjectMetadata
	}
	return nil
}

func (m *UpdateMetadataRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *UpdateMetadataRequest) GetMask() *google_protobuf2.FieldMask {
	if m != nil {
		return m.Mask
	}
	return nil
}

type UpdateMetadataResponse struct {
}

func (m *UpdateMetadataResponse) Reset()                    { *m = UpdateMetadataResponse{} }
func (m *UpdateMetadataResponse) String() string            { return proto1.CompactTextString(m) }
func (*UpdateMetadataResponse) ProtoMessage()               {}
func (*UpdateMetadataResponse) Descriptor() ([]byte, []int) { return fileDescriptor7, []int{5} }

type IngestBlueprintRequest struct {
	Source *SourceFilePath `protobuf:"bytes,1,opt,name=source" json:"source,omitempty"`
}

func (m *IngestBlueprintRequest) Reset()                    { *m = IngestBlueprintRequest{} }
func (m *IngestBlueprintRequest) String() string            { return proto1.CompactTextString(m) }
func (*IngestBlueprintRequest) ProtoMessage()               {}
func (*IngestBlueprintRequest) Descriptor() ([]byte, []int) { return fileDescriptor7, []int{6} }

func (m *IngestBlueprintRequest) GetSource() *SourceFilePath {
	if m != nil {
		return m.Source
	}
	return nil
}

type IngestBlueprintResponse struct {
}

func (m *IngestBlueprintResponse) Reset()                    { *m = IngestBlueprintResponse{} }
func (m *IngestBlueprintResponse) String() string            { return proto1.CompactTextString(m) }
func (*IngestBlueprintResponse) ProtoMessage()               {}
func (*IngestBlueprintResponse) Descriptor() ([]byte, []int) { return fileDescriptor7, []int{7} }

type ListTeamsRequest struct {
	// If true, also return any "archived" projects.
	IncludeArchived bool `protobuf:"varint,1,opt,name=include_archived,json=includeArchived" json:"include_archived,omitempty"`
}

func (m *ListTeamsRequest) Reset()                    { *m = ListTeamsRequest{} }
func (m *ListTeamsRequest) String() string            { return proto1.CompactTextString(m) }
func (*ListTeamsRequest) ProtoMessage()               {}
func (*ListTeamsRequest) Descriptor() ([]byte, []int) { return fileDescriptor7, []int{8} }

func (m *ListTeamsRequest) GetIncludeArchived() bool {
	if m != nil {
		return m.IncludeArchived
	}
	return false
}

type ListTeamsResponse struct {
	Teams []*ListTeamsResponse_TeamEntry `protobuf:"bytes,1,rep,name=teams" json:"teams,omitempty"`
}

func (m *ListTeamsResponse) Reset()                    { *m = ListTeamsResponse{} }
func (m *ListTeamsResponse) String() string            { return proto1.CompactTextString(m) }
func (*ListTeamsResponse) ProtoMessage()               {}
func (*ListTeamsResponse) Descriptor() ([]byte, []int) { return fileDescriptor7, []int{9} }

func (m *ListTeamsResponse) GetTeams() []*ListTeamsResponse_TeamEntry {
	if m != nil {
		return m.Teams
	}
	return nil
}

type ListTeamsResponse_TeamEntry struct {
	TeamName string `protobuf:"bytes,1,opt,name=team_name,json=teamName" json:"team_name,omitempty"`
	// Only the project_id and project_name will be populated in the ProjectMetadata.
	Projects []*ProjectMetadata `protobuf:"bytes,2,rep,name=projects" json:"projects,omitempty"`
}

func (m *ListTeamsResponse_TeamEntry) Reset()                    { *m = ListTeamsResponse_TeamEntry{} }
func (m *ListTeamsResponse_TeamEntry) String() string            { return proto1.CompactTextString(m) }
func (*ListTeamsResponse_TeamEntry) ProtoMessage()               {}
func (*ListTeamsResponse_TeamEntry) Descriptor() ([]byte, []int) { return fileDescriptor7, []int{9, 0} }

func (m *ListTeamsResponse_TeamEntry) GetTeamName() string {
	if m != nil {
		return m.TeamName
	}
	return ""
}

func (m *ListTeamsResponse_TeamEntry) GetProjects() []*ProjectMetadata {
	if m != nil {
		return m.Projects
	}
	return nil
}

type GetTeamRequest struct {
	TeamName string `protobuf:"bytes,1,opt,name=team_name,json=teamName" json:"team_name,omitempty"`
}

func (m *GetTeamRequest) Reset()                    { *m = GetTeamRequest{} }
func (m *GetTeamRequest) String() string            { return proto1.CompactTextString(m) }
func (*GetTeamRequest) ProtoMessage()               {}
func (*GetTeamRequest) Descriptor() ([]byte, []int) { return fileDescriptor7, []int{10} }

func (m *GetTeamRequest) GetTeamName() string {
	if m != nil {
		return m.TeamName
	}
	return ""
}

type GetTeamResponse struct {
	TeamName string `protobuf:"bytes,1,opt,name=team_name,json=teamName" json:"team_name,omitempty"`
	// Only the project_id and project_name will be populated in the ProjectMetadata.
	Projects []*ProjectMetadata `protobuf:"bytes,2,rep,name=projects" json:"projects,omitempty"`
}

func (m *GetTeamResponse) Reset()                    { *m = GetTeamResponse{} }
func (m *GetTeamResponse) String() string            { return proto1.CompactTextString(m) }
func (*GetTeamResponse) ProtoMessage()               {}
func (*GetTeamResponse) Descriptor() ([]byte, []int) { return fileDescriptor7, []int{11} }

func (m *GetTeamResponse) GetTeamName() string {
	if m != nil {
		return m.TeamName
	}
	return ""
}

func (m *GetTeamResponse) GetProjects() []*ProjectMetadata {
	if m != nil {
		return m.Projects
	}
	return nil
}

type ListOrgsRequest struct {
	// If true, also return any "archived" projects.
	IncludeArchived bool `protobuf:"varint,1,opt,name=include_archived,json=includeArchived" json:"include_archived,omitempty"`
	// If true, also include lists of projects under each team in response.
	IncludeProjects bool `protobuf:"varint,2,opt,name=include_projects,json=includeProjects" json:"include_projects,omitempty"`
}

func (m *ListOrgsRequest) Reset()                    { *m = ListOrgsRequest{} }
func (m *ListOrgsRequest) String() string            { return proto1.CompactTextString(m) }
func (*ListOrgsRequest) ProtoMessage()               {}
func (*ListOrgsRequest) Descriptor() ([]byte, []int) { return fileDescriptor7, []int{12} }

func (m *ListOrgsRequest) GetIncludeArchived() bool {
	if m != nil {
		return m.IncludeArchived
	}
	return false
}

func (m *ListOrgsRequest) GetIncludeProjects() bool {
	if m != nil {
		return m.IncludeProjects
	}
	return false
}

type ListOrgsResponse struct {
	Orgs []*ListOrgsResponse_OrgEntry `protobuf:"bytes,1,rep,name=orgs" json:"orgs,omitempty"`
}

func (m *ListOrgsResponse) Reset()                    { *m = ListOrgsResponse{} }
func (m *ListOrgsResponse) String() string            { return proto1.CompactTextString(m) }
func (*ListOrgsResponse) ProtoMessage()               {}
func (*ListOrgsResponse) Descriptor() ([]byte, []int) { return fileDescriptor7, []int{13} }

func (m *ListOrgsResponse) GetOrgs() []*ListOrgsResponse_OrgEntry {
	if m != nil {
		return m.Orgs
	}
	return nil
}

type ListOrgsResponse_OrgEntry struct {
	OrgName string                                 `protobuf:"bytes,1,opt,name=org_name,json=orgName" json:"org_name,omitempty"`
	Teams   []*ListOrgsResponse_OrgEntry_TeamEntry `protobuf:"bytes,2,rep,name=teams" json:"teams,omitempty"`
}

func (m *ListOrgsResponse_OrgEntry) Reset()                    { *m = ListOrgsResponse_OrgEntry{} }
func (m *ListOrgsResponse_OrgEntry) String() string            { return proto1.CompactTextString(m) }
func (*ListOrgsResponse_OrgEntry) ProtoMessage()               {}
func (*ListOrgsResponse_OrgEntry) Descriptor() ([]byte, []int) { return fileDescriptor7, []int{13, 0} }

func (m *ListOrgsResponse_OrgEntry) GetOrgName() string {
	if m != nil {
		return m.OrgName
	}
	return ""
}

func (m *ListOrgsResponse_OrgEntry) GetTeams() []*ListOrgsResponse_OrgEntry_TeamEntry {
	if m != nil {
		return m.Teams
	}
	return nil
}

type ListOrgsResponse_OrgEntry_TeamEntry struct {
	TeamName string `protobuf:"bytes,1,opt,name=team_name,json=teamName" json:"team_name,omitempty"`
	// Only the project_id and project_name will be populated in the ProjectMetadata.
	Projects []*ProjectMetadata `protobuf:"bytes,2,rep,name=projects" json:"projects,omitempty"`
}

func (m *ListOrgsResponse_OrgEntry_TeamEntry) Reset()         { *m = ListOrgsResponse_OrgEntry_TeamEntry{} }
func (m *ListOrgsResponse_OrgEntry_TeamEntry) String() string { return proto1.CompactTextString(m) }
func (*ListOrgsResponse_OrgEntry_TeamEntry) ProtoMessage()    {}
func (*ListOrgsResponse_OrgEntry_TeamEntry) Descriptor() ([]byte, []int) {
	return fileDescriptor7, []int{13, 0, 0}
}

func (m *ListOrgsResponse_OrgEntry_TeamEntry) GetTeamName() string {
	if m != nil {
		return m.TeamName
	}
	return ""
}

func (m *ListOrgsResponse_OrgEntry_TeamEntry) GetProjects() []*ProjectMetadata {
	if m != nil {
		return m.Projects
	}
	return nil
}

type GetOrgRequest struct {
	OrgName string `protobuf:"bytes,1,opt,name=org_name,json=orgName" json:"org_name,omitempty"`
	// If true, also include lists of projects under each team in response.
	IncludeProjects bool `protobuf:"varint,2,opt,name=include_projects,json=includeProjects" json:"include_projects,omitempty"`
}

func (m *GetOrgRequest) Reset()                    { *m = GetOrgRequest{} }
func (m *GetOrgRequest) String() string            { return proto1.CompactTextString(m) }
func (*GetOrgRequest) ProtoMessage()               {}
func (*GetOrgRequest) Descriptor() ([]byte, []int) { return fileDescriptor7, []int{14} }

func (m *GetOrgRequest) GetOrgName() string {
	if m != nil {
		return m.OrgName
	}
	return ""
}

func (m *GetOrgRequest) GetIncludeProjects() bool {
	if m != nil {
		return m.IncludeProjects
	}
	return false
}

type GetOrgResponse struct {
	OrgName string                      `protobuf:"bytes,1,opt,name=org_name,json=orgName" json:"org_name,omitempty"`
	Teams   []*GetOrgResponse_TeamEntry `protobuf:"bytes,2,rep,name=teams" json:"teams,omitempty"`
}

func (m *GetOrgResponse) Reset()                    { *m = GetOrgResponse{} }
func (m *GetOrgResponse) String() string            { return proto1.CompactTextString(m) }
func (*GetOrgResponse) ProtoMessage()               {}
func (*GetOrgResponse) Descriptor() ([]byte, []int) { return fileDescriptor7, []int{15} }

func (m *GetOrgResponse) GetOrgName() string {
	if m != nil {
		return m.OrgName
	}
	return ""
}

func (m *GetOrgResponse) GetTeams() []*GetOrgResponse_TeamEntry {
	if m != nil {
		return m.Teams
	}
	return nil
}

type GetOrgResponse_TeamEntry struct {
	TeamName string `protobuf:"bytes,1,opt,name=team_name,json=teamName" json:"team_name,omitempty"`
	// Only the project_id and project_name will be populated in the ProjectMetadata.
	Projects []*ProjectMetadata `protobuf:"bytes,2,rep,name=projects" json:"projects,omitempty"`
}

func (m *GetOrgResponse_TeamEntry) Reset()                    { *m = GetOrgResponse_TeamEntry{} }
func (m *GetOrgResponse_TeamEntry) String() string            { return proto1.CompactTextString(m) }
func (*GetOrgResponse_TeamEntry) ProtoMessage()               {}
func (*GetOrgResponse_TeamEntry) Descriptor() ([]byte, []int) { return fileDescriptor7, []int{15, 0} }

func (m *GetOrgResponse_TeamEntry) GetTeamName() string {
	if m != nil {
		return m.TeamName
	}
	return ""
}

func (m *GetOrgResponse_TeamEntry) GetProjects() []*ProjectMetadata {
	if m != nil {
		return m.Projects
	}
	return nil
}

func init() {
	proto1.RegisterType((*ListProjectsRequest)(nil), "rockpaperscissors.ListProjectsRequest")
	proto1.RegisterType((*ListProjectsResponse)(nil), "rockpaperscissors.ListProjectsResponse")
	proto1.RegisterType((*GetMetadataRequest)(nil), "rockpaperscissors.GetMetadataRequest")
	proto1.RegisterType((*GetMetadataResponse)(nil), "rockpaperscissors.GetMetadataResponse")
	proto1.RegisterType((*UpdateMetadataRequest)(nil), "rockpaperscissors.UpdateMetadataRequest")
	proto1.RegisterType((*UpdateMetadataResponse)(nil), "rockpaperscissors.UpdateMetadataResponse")
	proto1.RegisterType((*IngestBlueprintRequest)(nil), "rockpaperscissors.IngestBlueprintRequest")
	proto1.RegisterType((*IngestBlueprintResponse)(nil), "rockpaperscissors.IngestBlueprintResponse")
	proto1.RegisterType((*ListTeamsRequest)(nil), "rockpaperscissors.ListTeamsRequest")
	proto1.RegisterType((*ListTeamsResponse)(nil), "rockpaperscissors.ListTeamsResponse")
	proto1.RegisterType((*ListTeamsResponse_TeamEntry)(nil), "rockpaperscissors.ListTeamsResponse.TeamEntry")
	proto1.RegisterType((*GetTeamRequest)(nil), "rockpaperscissors.GetTeamRequest")
	proto1.RegisterType((*GetTeamResponse)(nil), "rockpaperscissors.GetTeamResponse")
	proto1.RegisterType((*ListOrgsRequest)(nil), "rockpaperscissors.ListOrgsRequest")
	proto1.RegisterType((*ListOrgsResponse)(nil), "rockpaperscissors.ListOrgsResponse")
	proto1.RegisterType((*ListOrgsResponse_OrgEntry)(nil), "rockpaperscissors.ListOrgsResponse.OrgEntry")
	proto1.RegisterType((*ListOrgsResponse_OrgEntry_TeamEntry)(nil), "rockpaperscissors.ListOrgsResponse.OrgEntry.TeamEntry")
	proto1.RegisterType((*GetOrgRequest)(nil), "rockpaperscissors.GetOrgRequest")
	proto1.RegisterType((*GetOrgResponse)(nil), "rockpaperscissors.GetOrgResponse")
	proto1.RegisterType((*GetOrgResponse_TeamEntry)(nil), "rockpaperscissors.GetOrgResponse.TeamEntry")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for ProjectMetadataService service

type ProjectMetadataServiceClient interface {
	// Returns a list of all projects registered with the system.
	ListProjects(ctx context.Context, in *ListProjectsRequest, opts ...grpc.CallOption) (*ListProjectsResponse, error)
	// Returns detailed information about one or more projects.
	GetMetadata(ctx context.Context, in *GetMetadataRequest, opts ...grpc.CallOption) (*GetMetadataResponse, error)
	// Updates metadata for a project.
	UpdateMetadata(ctx context.Context, in *UpdateMetadataRequest, opts ...grpc.CallOption) (*UpdateMetadataResponse, error)
	// Reads a blueprint from some code source, evaluates it, and then updates
	// the project metadata.
	IngestBlueprint(ctx context.Context, in *IngestBlueprintRequest, opts ...grpc.CallOption) (*IngestBlueprintResponse, error)
	// Get a list of development teams.
	// This is based on what team each project declares itself to be a part of.
	ListTeams(ctx context.Context, in *ListTeamsRequest, opts ...grpc.CallOption) (*ListTeamsResponse, error)
	// Get details about a development team.
	// This is based on what team each project declares itself to be a part of.
	GetTeam(ctx context.Context, in *GetTeamRequest, opts ...grpc.CallOption) (*GetTeamResponse, error)
	// Get a list of team organizations.
	// This is based on what org each project declares itself to be a part of.
	ListOrgs(ctx context.Context, in *ListOrgsRequest, opts ...grpc.CallOption) (*ListOrgsResponse, error)
	// Get details about an organization.
	// This is based on what org each project declares itself to be a part of.
	GetOrg(ctx context.Context, in *GetOrgRequest, opts ...grpc.CallOption) (*GetOrgResponse, error)
}

type projectMetadataServiceClient struct {
	cc *grpc.ClientConn
}

func NewProjectMetadataServiceClient(cc *grpc.ClientConn) ProjectMetadataServiceClient {
	return &projectMetadataServiceClient{cc}
}

func (c *projectMetadataServiceClient) ListProjects(ctx context.Context, in *ListProjectsRequest, opts ...grpc.CallOption) (*ListProjectsResponse, error) {
	out := new(ListProjectsResponse)
	err := grpc.Invoke(ctx, "/rockpaperscissors.ProjectMetadataService/ListProjects", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *projectMetadataServiceClient) GetMetadata(ctx context.Context, in *GetMetadataRequest, opts ...grpc.CallOption) (*GetMetadataResponse, error) {
	out := new(GetMetadataResponse)
	err := grpc.Invoke(ctx, "/rockpaperscissors.ProjectMetadataService/GetMetadata", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *projectMetadataServiceClient) UpdateMetadata(ctx context.Context, in *UpdateMetadataRequest, opts ...grpc.CallOption) (*UpdateMetadataResponse, error) {
	out := new(UpdateMetadataResponse)
	err := grpc.Invoke(ctx, "/rockpaperscissors.ProjectMetadataService/UpdateMetadata", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *projectMetadataServiceClient) IngestBlueprint(ctx context.Context, in *IngestBlueprintRequest, opts ...grpc.CallOption) (*IngestBlueprintResponse, error) {
	out := new(IngestBlueprintResponse)
	err := grpc.Invoke(ctx, "/rockpaperscissors.ProjectMetadataService/IngestBlueprint", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *projectMetadataServiceClient) ListTeams(ctx context.Context, in *ListTeamsRequest, opts ...grpc.CallOption) (*ListTeamsResponse, error) {
	out := new(ListTeamsResponse)
	err := grpc.Invoke(ctx, "/rockpaperscissors.ProjectMetadataService/ListTeams", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *projectMetadataServiceClient) GetTeam(ctx context.Context, in *GetTeamRequest, opts ...grpc.CallOption) (*GetTeamResponse, error) {
	out := new(GetTeamResponse)
	err := grpc.Invoke(ctx, "/rockpaperscissors.ProjectMetadataService/GetTeam", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *projectMetadataServiceClient) ListOrgs(ctx context.Context, in *ListOrgsRequest, opts ...grpc.CallOption) (*ListOrgsResponse, error) {
	out := new(ListOrgsResponse)
	err := grpc.Invoke(ctx, "/rockpaperscissors.ProjectMetadataService/ListOrgs", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *projectMetadataServiceClient) GetOrg(ctx context.Context, in *GetOrgRequest, opts ...grpc.CallOption) (*GetOrgResponse, error) {
	out := new(GetOrgResponse)
	err := grpc.Invoke(ctx, "/rockpaperscissors.ProjectMetadataService/GetOrg", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for ProjectMetadataService service

type ProjectMetadataServiceServer interface {
	// Returns a list of all projects registered with the system.
	ListProjects(context.Context, *ListProjectsRequest) (*ListProjectsResponse, error)
	// Returns detailed information about one or more projects.
	GetMetadata(context.Context, *GetMetadataRequest) (*GetMetadataResponse, error)
	// Updates metadata for a project.
	UpdateMetadata(context.Context, *UpdateMetadataRequest) (*UpdateMetadataResponse, error)
	// Reads a blueprint from some code source, evaluates it, and then updates
	// the project metadata.
	IngestBlueprint(context.Context, *IngestBlueprintRequest) (*IngestBlueprintResponse, error)
	// Get a list of development teams.
	// This is based on what team each project declares itself to be a part of.
	ListTeams(context.Context, *ListTeamsRequest) (*ListTeamsResponse, error)
	// Get details about a development team.
	// This is based on what team each project declares itself to be a part of.
	GetTeam(context.Context, *GetTeamRequest) (*GetTeamResponse, error)
	// Get a list of team organizations.
	// This is based on what org each project declares itself to be a part of.
	ListOrgs(context.Context, *ListOrgsRequest) (*ListOrgsResponse, error)
	// Get details about an organization.
	// This is based on what org each project declares itself to be a part of.
	GetOrg(context.Context, *GetOrgRequest) (*GetOrgResponse, error)
}

func RegisterProjectMetadataServiceServer(s *grpc.Server, srv ProjectMetadataServiceServer) {
	s.RegisterService(&_ProjectMetadataService_serviceDesc, srv)
}

func _ProjectMetadataService_ListProjects_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListProjectsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProjectMetadataServiceServer).ListProjects(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/rockpaperscissors.ProjectMetadataService/ListProjects",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProjectMetadataServiceServer).ListProjects(ctx, req.(*ListProjectsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProjectMetadataService_GetMetadata_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetMetadataRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProjectMetadataServiceServer).GetMetadata(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/rockpaperscissors.ProjectMetadataService/GetMetadata",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProjectMetadataServiceServer).GetMetadata(ctx, req.(*GetMetadataRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProjectMetadataService_UpdateMetadata_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateMetadataRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProjectMetadataServiceServer).UpdateMetadata(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/rockpaperscissors.ProjectMetadataService/UpdateMetadata",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProjectMetadataServiceServer).UpdateMetadata(ctx, req.(*UpdateMetadataRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProjectMetadataService_IngestBlueprint_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(IngestBlueprintRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProjectMetadataServiceServer).IngestBlueprint(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/rockpaperscissors.ProjectMetadataService/IngestBlueprint",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProjectMetadataServiceServer).IngestBlueprint(ctx, req.(*IngestBlueprintRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProjectMetadataService_ListTeams_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTeamsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProjectMetadataServiceServer).ListTeams(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/rockpaperscissors.ProjectMetadataService/ListTeams",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProjectMetadataServiceServer).ListTeams(ctx, req.(*ListTeamsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProjectMetadataService_GetTeam_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTeamRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProjectMetadataServiceServer).GetTeam(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/rockpaperscissors.ProjectMetadataService/GetTeam",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProjectMetadataServiceServer).GetTeam(ctx, req.(*GetTeamRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProjectMetadataService_ListOrgs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListOrgsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProjectMetadataServiceServer).ListOrgs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/rockpaperscissors.ProjectMetadataService/ListOrgs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProjectMetadataServiceServer).ListOrgs(ctx, req.(*ListOrgsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProjectMetadataService_GetOrg_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetOrgRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProjectMetadataServiceServer).GetOrg(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/rockpaperscissors.ProjectMetadataService/GetOrg",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProjectMetadataServiceServer).GetOrg(ctx, req.(*GetOrgRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ProjectMetadataService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "rockpaperscissors.ProjectMetadataService",
	HandlerType: (*ProjectMetadataServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListProjects",
			Handler:    _ProjectMetadataService_ListProjects_Handler,
		},
		{
			MethodName: "GetMetadata",
			Handler:    _ProjectMetadataService_GetMetadata_Handler,
		},
		{
			MethodName: "UpdateMetadata",
			Handler:    _ProjectMetadataService_UpdateMetadata_Handler,
		},
		{
			MethodName: "IngestBlueprint",
			Handler:    _ProjectMetadataService_IngestBlueprint_Handler,
		},
		{
			MethodName: "ListTeams",
			Handler:    _ProjectMetadataService_ListTeams_Handler,
		},
		{
			MethodName: "GetTeam",
			Handler:    _ProjectMetadataService_GetTeam_Handler,
		},
		{
			MethodName: "ListOrgs",
			Handler:    _ProjectMetadataService_ListOrgs_Handler,
		},
		{
			MethodName: "GetOrg",
			Handler:    _ProjectMetadataService_GetOrg_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "code.justin.tv/dta/rockpaperscissors/proto/project_metadata_service.proto",
}

func init() {
	proto1.RegisterFile("code.justin.tv/dta/rockpaperscissors/proto/project_metadata_service.proto", fileDescriptor7)
}

var fileDescriptor7 = []byte{
	// 878 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xc4, 0x56, 0x5f, 0x6f, 0xdb, 0x54,
	0x14, 0xc7, 0xd9, 0xd6, 0x24, 0x67, 0x5b, 0x93, 0xdd, 0xad, 0x5d, 0xe2, 0x31, 0x2d, 0xb9, 0x63,
	0xa3, 0x2b, 0x60, 0x8b, 0x4e, 0x42, 0xa2, 0x02, 0xd4, 0x56, 0xd0, 0xaa, 0x52, 0x4b, 0xab, 0x84,
	0xf2, 0x50, 0x09, 0x45, 0x17, 0xfb, 0xd6, 0x75, 0x9b, 0xd8, 0xc6, 0xf7, 0x26, 0x52, 0x55, 0xf5,
	0x05, 0x3e, 0x01, 0xe2, 0xab, 0xc0, 0x27, 0xe0, 0x8d, 0x57, 0x5e, 0x78, 0xe1, 0x8d, 0x0f, 0x82,
	0x7c, 0xef, 0x75, 0x6a, 0x3b, 0xae, 0x93, 0x16, 0xa1, 0xbe, 0xb4, 0xca, 0xb9, 0xe7, 0x9c, 0xdf,
	0xef, 0xfc, 0xc9, 0xf9, 0x05, 0xb6, 0x2d, 0xdf, 0xa6, 0xc6, 0xc9, 0x90, 0x71, 0xd7, 0x33, 0xf8,
	0xc8, 0xb4, 0x39, 0x31, 0x43, 0xdf, 0x3a, 0x0d, 0x48, 0x40, 0x43, 0x66, 0xb9, 0x8c, 0xf9, 0x21,
	0x33, 0x83, 0xd0, 0xe7, 0x7e, 0xf4, 0xf7, 0x84, 0x5a, 0xbc, 0x37, 0xa0, 0x9c, 0xd8, 0x84, 0x93,
	0x1e, 0xa3, 0xe1, 0xc8, 0xb5, 0xa8, 0x21, 0x9e, 0xd1, 0xa3, 0x89, 0x38, 0xfd, 0x5d, 0xc7, 0xf7,
	0x9d, 0x3e, 0x35, 0x49, 0xe0, 0x9a, 0xc4, 0xf3, 0x7c, 0x4e, 0xb8, 0xeb, 0x7b, 0x4c, 0x06, 0xe8,
	0x2d, 0xf5, 0x2a, 0x3e, 0x7d, 0x3f, 0x3c, 0x32, 0x8f, 0x5c, 0xda, 0xb7, 0x7b, 0x03, 0xc2, 0x4e,
	0x95, 0xc7, 0xfa, 0x7f, 0x60, 0x27, 0x53, 0xe0, 0x35, 0x78, 0xbc, 0xe3, 0x32, 0xbe, 0x2f, 0x5f,
	0x59, 0x87, 0xfe, 0x30, 0xa4, 0x8c, 0xa3, 0x37, 0x50, 0x77, 0x3d, 0xab, 0x3f, 0xb4, 0x69, 0x8f,
	0x84, 0xd6, 0xb1, 0x3b, 0xa2, 0x76, 0x43, 0x6b, 0x69, 0x4b, 0x95, 0x4e, 0x4d, 0xd9, 0xd7, 0x95,
	0x19, 0x7f, 0x0b, 0x4f, 0xd2, 0x19, 0x58, 0xe0, 0x7b, 0x8c, 0xa2, 0x2f, 0xa0, 0xa2, 0x30, 0x59,
	0x43, 0x6b, 0xdd, 0x59, 0xba, 0xbf, 0x82, 0x8d, 0x09, 0x72, 0x86, 0x0a, 0xdb, 0x55, 0xac, 0x3a,
	0xe3, 0x18, 0xfc, 0x16, 0xd0, 0x16, 0xbd, 0x7c, 0x50, 0xc4, 0x9e, 0x03, 0xc4, 0x95, 0xb8, 0x92,
	0x52, 0xb5, 0x53, 0x55, 0x96, 0x6d, 0x1b, 0x77, 0xe1, 0x71, 0x2a, 0x48, 0x71, 0xf9, 0x0c, 0xca,
	0xca, 0x47, 0x84, 0xcc, 0x46, 0x25, 0x0e, 0xc1, 0xbf, 0x69, 0xb0, 0x70, 0x10, 0xd8, 0x84, 0xd3,
	0x2c, 0x9b, 0x5d, 0xa8, 0x67, 0xfb, 0x7a, 0x0d, 0x80, 0x5a, 0x90, 0x36, 0x64, 0x8a, 0x2b, 0x65,
	0x8a, 0x43, 0x06, 0xdc, 0x8d, 0x86, 0xdf, 0xb8, 0x23, 0x10, 0x74, 0x43, 0xee, 0x87, 0x11, 0xef,
	0x87, 0xb1, 0x19, 0xed, 0xc7, 0x2e, 0x61, 0xa7, 0x1d, 0xe1, 0x87, 0x1b, 0xb0, 0x98, 0xa5, 0x2d,
	0xfb, 0x81, 0xbb, 0xb0, 0xb8, 0xed, 0x39, 0x94, 0xf1, 0x8d, 0xfe, 0x90, 0x06, 0xa1, 0xeb, 0xf1,
	0xb8, 0xa2, 0x4f, 0x61, 0x8e, 0xf9, 0xc3, 0xd0, 0xa2, 0xaa, 0x8e, 0x76, 0x4e, 0x1d, 0x5d, 0xe1,
	0xb0, 0xe9, 0xf6, 0xe9, 0x3e, 0xe1, 0xc7, 0x1d, 0x15, 0x80, 0x9b, 0xf0, 0x74, 0x22, 0xa9, 0xc2,
	0xfb, 0x1c, 0xea, 0xd1, 0x8e, 0x7c, 0x43, 0xc9, 0xe0, 0x26, 0x2b, 0xf6, 0xbb, 0x06, 0x8f, 0x12,
	0xf1, 0x6a, 0xa8, 0x5f, 0xc2, 0x3d, 0x1e, 0x19, 0xd4, 0x76, 0x19, 0x39, 0x4c, 0x27, 0x82, 0x8c,
	0xe8, 0xd3, 0x57, 0x1e, 0x0f, 0xcf, 0x3a, 0x32, 0x58, 0x3f, 0x86, 0xea, 0xd8, 0x86, 0x9e, 0x41,
	0x35, 0xb2, 0xf6, 0x3c, 0x32, 0xa0, 0x6a, 0xb9, 0x2a, 0x91, 0xe1, 0x6b, 0x32, 0x48, 0x2f, 0x74,
	0xe9, 0x06, 0x0b, 0xfd, 0x11, 0xcc, 0x6f, 0x51, 0x41, 0x27, 0x6e, 0x41, 0x11, 0x1c, 0xf6, 0xa0,
	0x36, 0x76, 0x57, 0x15, 0xff, 0xaf, 0xf4, 0x1c, 0xa8, 0x45, 0xed, 0xda, 0x0b, 0x9d, 0x1b, 0x8c,
	0x28, 0xe9, 0x9a, 0x60, 0x91, 0x74, 0x8d, 0x0f, 0x04, 0xfe, 0xb5, 0x24, 0xb7, 0x41, 0x22, 0xa9,
	0xd2, 0xd6, 0xe0, 0xae, 0x1f, 0x3a, 0xf1, 0x2c, 0x3f, 0xbc, 0x62, 0x96, 0xc9, 0x10, 0x63, 0x2f,
	0x74, 0xe4, 0x24, 0x45, 0xa4, 0xfe, 0xb7, 0x06, 0x95, 0xd8, 0x84, 0x9a, 0x50, 0xf1, 0x43, 0x27,
	0xd9, 0xa8, 0xb2, 0x1f, 0x3a, 0xa2, 0x4f, 0x3b, 0xf1, 0xda, 0xc8, 0x26, 0x7d, 0x72, 0x1d, 0xa8,
	0xdb, 0x5c, 0x9f, 0x03, 0x78, 0xb8, 0x45, 0x23, 0x5a, 0xf1, 0x74, 0x0a, 0x6a, 0xbc, 0xc6, 0x34,
	0xfe, 0xd2, 0xc4, 0x5a, 0x8a, 0xbc, 0x6a, 0x16, 0x05, 0x89, 0xd7, 0xd3, 0xcd, 0xfb, 0x20, 0xa7,
	0x82, 0x74, 0xb2, 0x5b, 0xec, 0xd8, 0xca, 0xcf, 0x15, 0x58, 0xcc, 0xbc, 0x76, 0xa5, 0x24, 0xa3,
	0x33, 0x78, 0x90, 0x14, 0x2d, 0xf4, 0xfa, 0x8a, 0x2d, 0xc8, 0xe8, 0xa2, 0xfe, 0xfe, 0x54, 0x3f,
	0x75, 0xf1, 0x1a, 0x3f, 0xfe, 0xf9, 0xcf, 0x2f, 0x25, 0x84, 0xea, 0x42, 0xdc, 0x47, 0x1f, 0xc7,
	0xfa, 0xcb, 0xd0, 0x4f, 0x1a, 0xdc, 0x4f, 0x68, 0x14, 0x7a, 0x95, 0xdf, 0xc3, 0x8c, 0xd4, 0xe8,
	0xaf, 0xa7, 0xb9, 0x29, 0xe0, 0x57, 0x02, 0xf8, 0x05, 0x7a, 0x9e, 0x05, 0x36, 0xcf, 0x2f, 0xb5,
	0xe5, 0x02, 0xfd, 0xa1, 0xc1, 0x7c, 0x5a, 0x1c, 0xd0, 0x52, 0x0e, 0x42, 0xae, 0xec, 0xe9, 0x6f,
	0x66, 0xf0, 0x54, 0x74, 0x2c, 0x41, 0xe7, 0x3b, 0xbd, 0x98, 0xce, 0xaa, 0xb6, 0x7c, 0x88, 0x57,
	0xa6, 0xfb, 0x2c, 0xe0, 0x89, 0x7e, 0xae, 0x6a, 0xcb, 0xe8, 0x04, 0x6a, 0x19, 0xe5, 0x41, 0x79,
	0x14, 0xf3, 0x25, 0x4f, 0x5f, 0x9e, 0xc5, 0x55, 0x95, 0xf3, 0x0e, 0x1a, 0x40, 0x75, 0xac, 0x2a,
	0xe8, 0x65, 0xb1, 0xe6, 0xc8, 0xfc, 0xef, 0xcd, 0x22, 0x4c, 0x78, 0x41, 0x34, 0xaa, 0x86, 0x1e,
	0xc6, 0x05, 0x8a, 0x6f, 0x0b, 0x62, 0x50, 0x56, 0x2a, 0x80, 0xda, 0xf9, 0x1b, 0x90, 0x10, 0x14,
	0x1d, 0x17, 0xb9, 0x28, 0xa0, 0xb6, 0x00, 0x7a, 0x86, 0x9a, 0x29, 0x20, 0xf3, 0x7c, 0xfc, 0x3d,
	0xbc, 0x40, 0x2e, 0x54, 0xe2, 0x13, 0x88, 0x70, 0xe1, 0x7d, 0x94, 0xb0, 0x2f, 0x67, 0xb8, 0xa1,
	0xf8, 0x89, 0xc0, 0x9d, 0x47, 0x0f, 0x62, 0xdc, 0xe8, 0x6a, 0x23, 0x0f, 0xe6, 0xe4, 0xc1, 0x40,
	0xad, 0x82, 0x5b, 0x22, 0x61, 0xda, 0x53, 0xaf, 0x0d, 0x7e, 0x21, 0x40, 0x9a, 0xe8, 0x69, 0x12,
	0xc4, 0x3c, 0x8f, 0xcf, 0xd9, 0xc5, 0x46, 0xf9, 0xf0, 0x9e, 0xfc, 0xbd, 0x34, 0x27, 0xfe, 0xbd,
	0xfd, 0x37, 0x00, 0x00, 0xff, 0xff, 0x47, 0x68, 0x41, 0x7a, 0xe2, 0x0b, 0x00, 0x00,
}
