#!/bin/bash

set -e

function abspath()
{
  (cd $1 && pwd)
}

go run ../vendor/code.justin.tv/common/chitin/protoc_gen/protoc.go -verbose -start .

protoc -I/usr/local/include -I. \
 -I$GOPATH/src \
 -I$(abspath ../vendor/github.com/grpc-ecosystem/grpc-gateway/third_party/googleapis) \
 --grpc-gateway_out=logtostderr=true:. \
 *_service.proto


# Fixup bad import lines added by the "eg" tool run by protoc_gen
sed -i -e "s/code\.justin\.tv\/dta\/rockpaperscissors\/vendor\///" *.pb.go
