#!/bin/bash

set -e

if [ -z "$1" ]; then
  echo "Output directory argument is required"
  exit 1
fi

function abspath() {
    # generate absolute path from relative path
    # $1     : relative filename
    # return : absolute path
    if [ -d "$1" ]; then
        # dir
        (cd "$1"; pwd)
    elif [ -f "$1" ]; then
        # file
        if [[ $1 == */* ]]; then
            echo "$(cd "${1%/*}"; pwd)/${1##*/}"
        else
            echo "$(pwd)/$1"
        fi
    fi
}

if [ ! -d "$1" ]; then
  mkdir "$1"
fi
OUT=$(abspath $1)
SRCROOT=$(abspath $(dirname $0)/..)
cd ${SRCROOT}

# Build the alpine version of rockpaperscissors for our docker container.
# It has to be statically compiled.
CC=/usr/local/musl/bin/musl-gcc go build -a \
    -ldflags '-w -linkmode external -extldflags "-static"' \
    -o "${OUT}/rockpaperscissors.alpine" \
    ./cmd/rockpaperscissors/main.go
