#!/bin/bash

set -e

function abspath() {
    # generate absolute path from relative path
    # $1     : relative filename
    # return : absolute path
    if [ -d "$1" ]; then
        # dir
        (cd "$1"; pwd)
    elif [ -f "$1" ]; then
        # file
        if [[ $1 == */* ]]; then
            echo "$(cd "${1%/*}"; pwd)/${1##*/}"
        else
            echo "$(pwd)/$1"
        fi
    fi
}

destdir=$(abspath $1)
rootdir=$(abspath $(dirname $0)/..)

protoc --proto_path=${GOPATH}/src \
  --proto_path=${rootdir}/vendor \
  --proto_path=${rootdir}/vendor/github.com/grpc-ecosystem/grpc-gateway/third_party/googleapis \
  --python_out=${destdir}/ \
  ${rootdir}/proto/*.proto ${rootdir}/proto/events/*.proto
(
   cd ${rootdir}/vendor/github.com/grpc-ecosystem/grpc-gateway/third_party/googleapis
   protoc --python_out=${destdir} google/api/*.proto
)
touch ${destdir}/google/__init__.py
touch ${destdir}/google/api/__init__.py
