variable "name" {
  default = "rockpaperscissors"
}

variable "environment" {
  default = "development"
}

variable "owner" {
  default = "dta@twitch.tv"
}

variable "project" {
  default = "dta/rockpaperscissors"
}

variable "instance_type" {
  default = "t2.micro"
}

variable "subnet_ids" {
  default = "subnet-ebcd859c,subnet-23b19b46,subnet-c543209c"
}

variable "security_groups" {
  default = "sg-09387e6d,sg-4d3b7d29"
}

variable "account_id" {
  default = "043714768218"
}

data "terraform_remote_state" "beanstalk_app" {
  backend = "s3"

  config {
    bucket = "tw-devtools"
    key    = "tfstate/dta/rockpaperscissors/terraform/beanstalk_app"
  }
}

module "rockpaperscissors_env" {
  source                    = "../modules/rockpaperscissors-env"
  name                      = "${var.name}"
  owner                     = "${var.owner}"
  project                   = "${var.project}"
  eb_application_name       = "${var.name}"
  instance_type             = "${var.instance_type}"
  environment               = "${var.environment}"
  events_table_name         = "${module.rockpaperscissors_datastores.events_table_name}"
  events_table_arn          = "${module.rockpaperscissors_datastores.events_table_arn}"
  projects_table_name       = "${module.rockpaperscissors_datastores.projects_table_name}"
  projects_table_arn        = "${module.rockpaperscissors_datastores.projects_table_arn}"
  sandstorm_role_arn        = "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/devtools-development-rockpaperscissors"
  ingest_queue_name         = "${module.rockpaperscissors_datastores.ingest_queue_name}"
  ingest_queue_arn          = "${module.rockpaperscissors_datastores.ingest_queue_arn}"
  vpc_id                    = "vpc-0184df64"
  subnet_ids                = "${var.subnet_ids}"
  security_groups           = "${var.security_groups}"
  github_webhook_url        = "${module.rockpaperscissors_github_handler.webhook_url}"
  memcached_config_endpoint = "${module.rockpaperscissors_datastores.memcached_configuration_endpoint}"
}

module "rockpaperscissors_datastores" {
  source                        = "../modules/rockpaperscissors-datastores"
  name                          = "${var.name}"
  project                       = "${var.project}"
  owner                         = "${var.owner}"
  environment                   = "${var.environment}"
  subnet_ids                    = "${var.subnet_ids}"
  security_groups               = "${var.security_groups}"
  account_id                    = "${var.account_id}"
  projects_table_read_capacity  = 5
  projects_table_write_capacity = 1
  events_table_read_capacity    = 5
  events_table_write_capacity   = 5
  eventtype_gsi_read_capacity   = 15
  eventtype_gsi_write_capacity  = 5
  memcached_cluster_name        = "rps-dev"                                 # rockpaperscissors-development is too long
}

module "rockpaperscissors_github_handler" {
  source                                 = "../modules/rockpaperscissors-github-handler"
  name                                   = "${var.name}"
  project                                = "${var.project}"
  owner                                  = "${var.owner}"
  environment                            = "${var.environment}"
  event_stream_arn                       = "${module.rockpaperscissors_datastores.event_stream_arn}"
  subnet_ids                             = "${var.subnet_ids}"
  security_groups                        = "${var.security_groups}"
  github_webhook_handler_rest_api_id     = "${data.terraform_remote_state.beanstalk_app.github_webhook_handler_rest_api_id}"
  github_webhook_handler_deployment_name = "${data.terraform_remote_state.beanstalk_app.github_webhook_handler_deployment_name}"
  github_webhook_handler_resource_id     = "${data.terraform_remote_state.beanstalk_app.github_webhook_handler_resource_id}"
  account_id                             = "${var.account_id}"
  large_events_s3_bucket_arn             = "${module.rockpaperscissors_datastores.s3_bucket_arn}"
}

module "rockpaperscissors_blueprint_ingest" {
  source           = "../modules/rockpaperscissors-blueprint-ingest"
  name             = "${var.name}"
  project          = "${var.project}"
  owner            = "${var.owner}"
  environment      = "${var.environment}"
  event_stream_arn = "${module.rockpaperscissors_datastores.event_stream_arn}"
  ingest_queue_arn = "${module.rockpaperscissors_datastores.ingest_queue_arn}"
  subnet_ids       = "${var.subnet_ids}"
  security_groups  = "${var.security_groups}"
  account_id       = "${var.account_id}"
}

module "rockpaperscissors_github_stats" {
  source           = "../modules/rockpaperscissors-github-stats"
  name             = "${var.name}"
  project          = "${var.project}"
  owner            = "${var.owner}"
  environment      = "${var.environment}"
  event_stream_arn = "${module.rockpaperscissors_datastores.event_stream_arn}"
  ingest_queue_arn = "${module.rockpaperscissors_datastores.ingest_queue_arn}"
  subnet_ids       = "${var.subnet_ids}"
  security_groups  = "${var.security_groups}"
  account_id       = "${var.account_id}"
}

module "rockpaperscissors_jira_scraper" {
  source             = "../modules/rockpaperscissors-jira-scraper"
  name               = "${var.name}"
  project            = "${var.project}"
  owner              = "${var.owner}"
  environment        = "${var.environment}"
  event_stream_arn   = "${module.rockpaperscissors_datastores.event_stream_arn}"
  sandstorm_role_arn = "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/devtools-development-rockpaperscissors"
  subnet_ids         = "${var.subnet_ids}"
  security_groups    = "${var.security_groups}"
  account_id         = "${var.account_id}"
}
