variable "name" {
  description = "Service name used for AWS tagging among other things. #REQUIRED"
}

variable "environment" {
  description = "Service environment. #REQUIRED"
}

variable "pagerduty_endpoint" {
  description = "URL of PagerDuty endpoint to subscribe to the alerts SNS. #REQUIRED"
}

variable "kinesis_stream_name" {
  description = "Name of the events bus Kinesis stream. #REQUIRED"
}

variable "event_store_lambda_name" {
  description = "Name of the event_store Lambda function. #REQUIRED"
}

variable "blueprint_ingest_lambda_name" {
  description = "Name of the blueprint_ingest Lambda function. #REQUIRED"
}

variable "github_stats_lambda_name" {
  description = "Name of the github_stats Lambda function. #REQUIRED"
}

variable "jira_scraper_lambda_name" {
  description = "Name of the jira_scraper Lambda function. #REQUIRED"
}

variable "github_webhook_lambda_name" {
  description = "Name of the github_webhook Lambda function. #REQUIRED"
}

variable "worker_queue_name" {
  description = "Name of the worker SQS queue. #REQUIRED"
}

variable "eb_environment_name" {
  description = "Name of the Elastic Beanstalk environment. #REQUIRED"
}

variable "github_webhook_api_name" {
  description = "Name of the GitHub Webhook API Gateway. #REQUIRED"
}

variable "github_webhook_stage_name" {
  description = "Name of the GitHub Webhook API Gateway stage. #REQUIRED"
}

variable "events_table_name" {
  description = "Name of the events DynamoDB table. #REQUIRED"
}

variable "projects_table_name" {
  description = "Name of the projects DynamoDB table. #REQUIRED"
}

variable "projects_table_read_capacity" {
  description = "Read capacity for projects DynamoDB table. #REQUIRED"
}

variable "projects_table_write_capacity" {
  description = "Write capacity for projects DynamoDB table. #REQUIRED"
}

variable "events_table_read_capacity" {
  description = "Read capacity for events DynamoDB table. #REQUIRED"
}

variable "events_table_write_capacity" {
  description = "Write capacity for events DynamoDB table. #REQUIRED"
}

variable "eventtype_gsi_read_capacity" {
  description = "Read capacity for EventTypeIndex DynamoDB Global Secondary Index. #REQUIRED"
}

variable "eventtype_gsi_write_capacity" {
  description = "Write capacity for EventTypeIndex DynamoDB Global Secondary Index. #REQUIRED"
}
