# Give the role access to the blueprint ingest queue.
resource "aws_iam_role_policy" "blueprint_ingest_policy" {
  name   = "${var.name}-${var.environment}-blueprint-ingest"
  policy = "${data.aws_iam_policy_document.iam_role_policy.json}"
  role   = "${module.tf_lambda_app.role_id}"
}

data "aws_iam_policy_document" "iam_role_policy" {
  statement {
    actions = [
      "kinesis:DescribeStream",
      "kinesis:GetShardIterator",
      "kinesis:GetRecords",
      "kinesis:ListStreams",
    ]

    resources = [
      "${var.event_stream_arn}",
    ]
  }

  statement {
    actions = [
      "lambda:InvokeFunction",
    ]

    resources = [
      "${module.tf_lambda_app.arn}",
    ]
  }

  statement {
    actions = [
      "sqs:SendMessage",
      "sqs:SendMessageBatch",
      "sqs:GetQueueUrl",
      "sqs:ListQueues",
    ]

    resources = [
      "${var.ingest_queue_arn}",
    ]
  }
}
