# Lambda function that subscribes to the kinesis stream and writes events to the
# events table.
module "tf_lambda_app" {
  source                        = "git::git+ssh://git@git-aws.internal.justin.tv/dta/tf_lambda_app.git?ref=1.4.1"
  owner                         = "${var.owner}"
  repository                    = "${var.project}"
  environment                   = "${var.environment}"
  principal                     = "${var.account_id}"
  lambda_handler                = "blueprint_ingest.lambda_handler"
  lambda_function_name          = "${var.name}-${var.environment}-bp"
  lambda_description            = "Looks for changes to *.blueprint files in GitHub push events sent to a kinesis stream."
  lambda_runtime                = "python2.7"
  aws_region                    = "${var.aws_region}"
  lambda_vpc_subnet_ids         = "${var.subnet_ids}"
  lambda_vpc_security_group_ids = "${var.security_groups}"
  lambda_timeout                = "30"
}

# Have the lambda receive events from the kinesis stream.
resource "aws_lambda_event_source_mapping" "event_source_mapping" {
  batch_size        = 100
  event_source_arn  = "${var.event_stream_arn}"
  enabled           = true
  function_name     = "${module.tf_lambda_app.arn}"
  starting_position = "TRIM_HORIZON"
}
