# Give the role access to the kinesis stream.
resource "aws_iam_role_policy" "kinesis_policy" {
  name   = "${var.name}-${var.environment}-kinesis"
  policy = "${data.aws_iam_policy_document.iam_role_policy.json}"
  role   = "${module.tf_lambda_app.role_id}"
}

data "aws_iam_policy_document" "iam_role_policy" {
  statement {
    actions = [
      "kinesis:DescribeStream",
      "kinesis:GetShardIterator",
      "kinesis:GetRecords",
      "kinesis:ListStreams",
    ]

    resources = [
      "${aws_kinesis_stream.event_stream.arn}",
    ]
  }

  statement {
    actions = [
      "lambda:InvokeFunction",
    ]

    resources = [
      "${module.tf_lambda_app.arn}",
    ]
  }

  statement {
    actions = [
      "dynamodb:BatchWriteItem",
    ]

    resources = [
      "${aws_dynamodb_table.events_table.arn}",
    ]
  }

  statement {
    actions = [
      "s3:ListAllMyBuckets",
      "s3:GetBucketLocation",
      "s3:ListBucket",
    ]

    resources = [
      "${aws_s3_bucket.s3_bucket.arn}",
    ]
  }

  statement {
    actions = [
      "s3:PutObject",
      "s3:PutObjectAcl",
    ]

    resources = [
      "${aws_s3_bucket.s3_bucket.arn}/*",
    ]
  }
}
